using System;
using System.Windows.Forms;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading;
using System.Diagnostics;
using LFS_External;
using LFS_External.InSim;

namespace LFS_External_Client
{
	public partial class Form1 : Form
    {
        string AdminPW = "myadmpwd";
        ushort Port = 29999;
        string IPAddress = "localhost";
        static public bool raceStarted = false;
        static public bool winnerSet = false;
        static public byte winnerUCID = 0;
        static public byte lastRaceWinnerUCID = 0;
        static public string nextRaceCar = "FOX";
        static public string lastRaceCar = "UF1";
        static public byte nextRaceIntRest = 0;
        static public byte nextRaceAddMass = 0;
        static public bool nextCarSet = true;
        static public bool intRestEnabled = false;
        static public bool addMassEnabled = false;
        static public byte timeToResRace = 60;
        static public byte timeSinceEndOfRace = 255;
        static public bool raceResCountdown = false;
        static public string hostName = "LFS Host";
        static public string voteVote = "";
        static public byte voteVotes = 0;
        static public string voteVoters = "";
        static public byte voteIdleTime = 255;
        static public bool voteExpired = false;
        static public byte timerPauseLeftTime = 60;
        static public bool timerPaused = false;


		// Main InSim object
		static public InSimInterface InSim;

		// InSim connection settings
        InSimSettings Settings = new InSimSettings("78.110.160.85", 29003, 0, Flags.InSimFlags.ISF_MSO_COLS | Flags.InSimFlags.ISF_MCI, '!', 500, "12wsxc", "^3-OsT-", 5);

		// These are the main lists that contain all Players and Connections (Being maintained automatically)
		static public List<clsConnection> Connections = new List<clsConnection>();
        static public List<clsPlayer> Players = new List<clsPlayer>();

		// Delegate for UI update (Example)
		delegate void dlgMSO(Packets.IS_MSO MSO);

		// Form constructor
		public Form1()
		{
			InitializeComponent();
			InSimConnect();	// Attempt to connect to InSim
		}

		// Always call .Close() on application exit
		private void Form1_FormClosing(object sender, FormClosingEventArgs e)
		{
            try
            {
                foreach (clsConnection C in Connections)
                {
                    dbProcess.userUpdateStats(C);
                }
                InSim.Close();
                Application.Exit();
            }
            finally
            {
                Process.GetCurrentProcess().Kill();
            }
		}

		// Use this method to connect to InSim so you are able to catch any exception that might occure
		private void InSimConnect()
        {
            try
            {
                if (System.IO.File.Exists(@"settings.ini") == false)
                {
                    File.Create(@"settings.ini");
                }
                StreamReader Sr = new StreamReader("settings.ini");

                while (Sr.Peek() >= 0)
                {
                    string line = Sr.ReadLine();
                    string[] StrLn = line.Split(' ');

                    switch (StrLn[0])
                    {
                        case "Admin":
                            try
                            {
                                AdminPW = line.Remove(0, StrLn[0].Length + 1);
                            }
                            catch { }
                            break;

                        case "Port":
                            try
                            {
                                Port = Convert.ToUInt16(line.Remove(0, StrLn[0].Length + 1));
                            }
                            catch { }
                            break;

                        case "IP":
                            try
                            {
                                IPAddress = line.Remove(0, StrLn[0].Length + 1);
                            }
                            catch { }
                            break;

                        case "carsGlobStr":
                            globalVars.allowedCarsGlobal = line.Remove(0, StrLn[0].Length + 1);
                            break;
                    }
                }
                Sr.Close();
            }
            catch { }
            InSimSettings Setts2 = new InSimSettings(IPAddress, Port, 0, Flags.InSimFlags.ISF_MSO_COLS | Flags.InSimFlags.ISF_MCI, '!', 500, AdminPW, "^3-OsT-", 5);

			try
			{
				InSim = new InSimInterface(Setts2);	// Initialize a new instance of InSimInterface with the settings specified above
				InSim.ConnectionLost += new InSimInterface.ConnectionLost_EventHandler(LostConnectionToInSim);	// Occurs when connection was lost due to an unknown reason
				InSim.Reconnected += new InSimInterface.Reconnected_EventHandler(ReconnectedToInSim);			// Occurs when connection was recovert automatically

				InitializeInSimEvents();				// Initialize packet receive events
				InSim.Connect();						// Attempt to connect to the InSim host 
			}
			catch (InvalidConfigurationException ex)
			{
                misc.buildErrorReportOnCrash(ex, "ISC-IVC", "ISC(IVC)", null, "/globalError");
			}
			catch (UnableToConnectToInSimException ex)
            {
                misc.buildErrorReportOnCrash(ex, "ISC-UNC", "ISC(UNC)", null, "/globalError");
			}
			catch (AdminPasswordDoesNotMatchException ex)
            {
                misc.buildErrorReportOnCrash(ex, "ISC-PNM", "ISC(PNM)", null, "/globalError");
			}
			catch (UDPListenPortAlreadyInUseException ex)
            {
                misc.buildErrorReportOnCrash(ex, "ISC-PIU", "ISC(PIU)", null, "/globalError");
			}
			catch (AutoReconnectFailedException ex)
            {
                misc.buildErrorReportOnCrash(ex, "ISC-ARF", "ISC(ARF)", null, "/globalError");
			}
			catch (Exception ex)
            {
                misc.buildErrorReportOnCrash(ex, "ISC-TWR(UNN)", "ISC(UNN)", null, "/globalError");
			}
			finally
			{
				if (InSim.State == LFS_External.InSim.InSimInterface.InSimState.Connected)
				{
					// Request all players and connections so we can build the Connections and Players list
					InSim.Request_NCN_AllConnections(255);
					InSim.Request_NPL_AllPlayers(255);
                    InSim.Send_MST_Message("/cars ALL");
                    InSim.Request_STA_State(9);
				}
			}
		}

		// Occurs when connection was lost due to an unknown reason
		private void LostConnectionToInSim()
		{
		}

		// Occurs when connection was recovert automatically
		private void ReconnectedToInSim()
		{
			// You should request all connections and players again so you can check changes in the corresponding lists
		}
		
		// You should only enable the events you need to gain maximum performance. All events are enable by default.
		private void InitializeInSimEvents()
		{
			// Client information
			InSim.NCN_Received += new LFS_External.InSim.InSimInterface.NCN_EventHandler(NCN_ClientJoinsHost);				// A new client joined the server.
			InSim.CNL_Received += new LFS_External.InSim.InSimInterface.CNL_EventHandler(CNL_ClientLeavesHost);				// A client left the server.
			InSim.CPR_Received += new LFS_External.InSim.InSimInterface.CPR_EventHandler(CPR_ClientRenames);				// A client changed name or plate.
			InSim.PFL_Received += new LFS_External.InSim.InSimInterface.PFL_EventHandler(PFL_PlayerFlagsChanged);			// Player help settings changed.
			InSim.PLP_Received += new LFS_External.InSim.InSimInterface.PLP_EventHandler(PLP_PlayerGoesToGarage);			// A player goes to the garage (setup screen).
			InSim.NPL_Received += new LFS_External.InSim.InSimInterface.NPL_EventHandler(NPL_PlayerJoinsRace);				// A player join the race. If PLID already exists, then player leaves pit.
			InSim.LAP_Received += new LFS_External.InSim.InSimInterface.LAP_EventHandler(LAP_PlayerCompletesLap);			// A player crosses start/finish line
			InSim.TOC_Received += new LFS_External.InSim.InSimInterface.TOC_EventHandler(TOC_PlayerCarTakeOver);			// Car got taken over by an other player
			InSim.FIN_Received += new LFS_External.InSim.InSimInterface.FIN_EventHandler(FIN_PlayerFinishedRaces);			// A player finishes race and crosses the finish line
			InSim.CRS_Received += new LFS_External.InSim.InSimInterface.CRS_EventHandler(CRS_PlayerResetsCar);				// A player resets the car
			InSim.PIT_Received += new LFS_External.InSim.InSimInterface.PIT_EventHandler(PIT_PlayerStopsAtPit);				// A player stops for making a pitstop
			InSim.PSF_Received += new LFS_External.InSim.InSimInterface.PSF_EventHandler(PSF_PitStopFinished);				// A pitstop got finished
			InSim.AXO_Received += new LFS_External.InSim.InSimInterface.AXO_EventHandler(AXO_PlayerHitsAutocrossObject);	// A player hits an autocross object
			InSim.PLL_Received += new LFS_External.InSim.InSimInterface.PLL_EventHandler(PLL_PlayerLeavesRace);				// A player leaves the race (spectate)
			InSim.BFN_Received += new LFS_External.InSim.InSimInterface.BFN_EventHandler(BFN_PlayerRequestsButtons);		// A player pressed Shift+I or Shift+B
			InSim.BTC_Received += new LFS_External.InSim.InSimInterface.BTC_EventHandler(BTC_ButtonClicked);				// A player clicked a custom button
			InSim.BTT_Received += new LFS_External.InSim.InSimInterface.BTT_EventHandler(BTT_TextBoxOkClicked);				// A player submitted a custom textbox
			InSim.PEN_Received += new LFS_External.InSim.InSimInterface.PEN_EventHandler(PEN_PenaltyChanged);				// A penalty give or cleared
			InSim.FLG_Received += new LFS_External.InSim.InSimInterface.FLG_EventHandler(FLG_FlagChanged);					// Yellow or blue flag changed
			InSim.PLA_Received += new LFS_External.InSim.InSimInterface.PLA_EventHandler(PLA_PitLaneChanged);				// A player entered or left the pitlane
			InSim.SPX_Received += new LFS_External.InSim.InSimInterface.SPX_EventHandler(SPX_SplitTime);					// A player crossed a lap split
			InSim.CCH_Received += new LFS_External.InSim.InSimInterface.CCH_EventHandler(CCH_CameraChanged);				// A player changed it's camera

			// Host and race information
			InSim.STA_Received += new LFS_External.InSim.InSimInterface.STA_EventHandler(STA_StateChanged);					// The server/race state changed
			InSim.ISM_Received += new LFS_External.InSim.InSimInterface.ISM_EventHandler(ISM_MultiplayerInformation);		// A host is started or joined
			InSim.MPE_Received += new LFS_External.InSim.InSimInterface.MPE_EventHandler(MPE_MultiplayerEnd);				// A host ends or leaves
			InSim.CLR_Received += new LFS_External.InSim.InSimInterface.CLR_EventHandler(CLR_RaceCleared);					// Race got cleared with /clear
			InSim.REO_Received += new LFS_External.InSim.InSimInterface.REO_EventHandler(REO_RaceStartOrder);				// Sent at the start of every race or qualifying session, listing the start order
			InSim.RST_Received += new LFS_External.InSim.InSimInterface.RST_EventHandler(RST_RaceStart);					// A race starts
			InSim.RES_Received += new LFS_External.InSim.InSimInterface.RES_EventHandler(RES_RaceOrQualifyingResult);		// Qualify or confirmed finish
			InSim.REN_Received += new LFS_External.InSim.InSimInterface.REN_EventHandler(REN_RaceEnds);						// A race ends (return to game setup screen)
			InSim.RTP_Received += new LFS_External.InSim.InSimInterface.RTP_EventHandler(RTP_RaceTime);						// Current race time progress in hundredths
			InSim.AXC_Received += new LFS_External.InSim.InSimInterface.AXC_EventHandler(AXC_AutocrossCleared);				// Autocross got cleared
			InSim.AXI_Received += new LFS_External.InSim.InSimInterface.AXI_EventHandler(AXI_AutocrossLayoutInformation);	// Request - autocross layout information
			InSim.CPP_Received += new LFS_External.InSim.InSimInterface.CPP_EventHandler(CPP_CameraPosition);				// LFS reporting camera position and state
			InSim.VTA_Received += new LFS_External.InSim.InSimInterface.VTA_EventHandler(VTA_VoteAction);					// A vote completed
			InSim.VTC_Received += new LFS_External.InSim.InSimInterface.VTC_EventHandler(VTC_VoteCanceled);					// A vote got canceled
			InSim.VTN_Received += new LFS_External.InSim.InSimInterface.VTN_EventHandler(VTN_VoteNotify);					// A vote got called

			// Car tracking
			InSim.MCI_Received += new LFS_External.InSim.InSimInterface.MCI_EventHandler(MCI_CarInformation);				// Detailed car information packet (max 8 per packet)
			InSim.NLP_Received += new LFS_External.InSim.InSimInterface.NLP_EventHandler(NLP_LapNode);						// Compact car information packet

			// Other
			InSim.MSO_Received += new LFS_External.InSim.InSimInterface.MSO_EventHandler(MSO_MessageOut);					// Player chat and system messages.
			InSim.III_Received += new LFS_External.InSim.InSimInterface.III_EventHandler(III_InSimInfo);					// A /i message got sent to this program
			InSim.VER_Received += new LFS_External.InSim.InSimInterface.VER_EventHandler(VER_InSimVersionInformation);		// InSim version information
			InSim.REPLY_Received += new LFS_External.InSim.InSimInterface.REPLY_EventHandler(REPLY_PingReplay);				// Reply to a ping request
		}

		#region ' Utils '
		// Methods for automatically update Players[] and Connection[] lists
		private void RemoveFromConnectionsList(byte ucid)
		{
			// Copy of item to remove
			clsConnection RemoveItem = new clsConnection();

			// Check what item the connection had
			foreach (clsConnection Conn in Connections)
			{
				if (ucid == Conn.UniqueID)
				{
					// Copy item (Can't delete it here)
					RemoveItem = Conn;
					continue;
				}
			}

			// Remove item
			Connections.Remove(RemoveItem);
		}
		private void AddToConnectionsList(Packets.IS_NCN NCN)
		{
			bool InList = false;

			// Check of connection is already in the list
			foreach (clsConnection Conn in Connections)
			{
				if (Conn.UniqueID == NCN.UCID)
				{
					InList = true;
					continue;
				}
			}

			// If not, add it
			if (!InList)
			{
				// Assign values of new connnnection.
				clsConnection NewConn = new clsConnection();
				NewConn.UniqueID = NCN.UCID;
				NewConn.Username = NCN.UName;
				NewConn.PlayerName = NCN.PName;
				NewConn.IsAdmin = NCN.Admin;
				NewConn.Flags = NCN.Flags;

				Connections.Add(NewConn);
			}
		}
		private void RemoveFromPlayersList(byte plid)
		{
			// Copy of item to remove
			clsPlayer RemoveItem = new clsPlayer();

			// Check what item the player had
			foreach (clsPlayer Player in Players)
			{
				if (plid == Player.PlayerID)
				{
					// Copy item (Can't delete it here)
					RemoveItem = Player;
                    Connections[GetConnIdx(Player.UniqueID)].PlayerID = 0;
					continue;
				}
			}

			// Remove item
			Players.Remove(RemoveItem);
		}
		private bool AddToPlayersList(Packets.IS_NPL NPL)
		{
			bool InList = false;

			// Check if player is already in the list
			foreach (clsPlayer Player in Players)
			{
				if (Player.PlayerID == NPL.PLID)
				{
					Player.AddedMass = NPL.H_Mass;
					Player.CarName = NPL.CName;
					Player.Flags = NPL.Flags;
					Player.Passengers = NPL.Pass;
					Player.Plate = NPL.Plate;
					Player.PlayerType = (clsPlayer.enuPType)NPL.PType;
					Player.SkinName = NPL.SName;
					Player.Tyre_FL = NPL.Tyre_FL;
					Player.Tyre_FR = NPL.Tyre_FR;
					Player.Tyre_RL = NPL.Tyre_RL;
					Player.Tyre_RR = NPL.Tyre_RR;
                    Player.IntakeRestriction = NPL.H_TRes;
                    Connections[GetConnIdx(NPL.UCID)].PlayerID = NPL.PLID;
					return true;
				}
			}

			// If not, add it
			if (!InList)
			{
				// Assign values of new player.
				clsPlayer NewPlayer = new clsPlayer();
				NewPlayer.AddedMass = NPL.H_Mass;
				NewPlayer.CarName = NPL.CName;
				NewPlayer.Flags = NPL.Flags;
				NewPlayer.Passengers = NPL.Pass;
				NewPlayer.Plate = NPL.Plate;
				NewPlayer.PlayerID = NPL.PLID;
				NewPlayer.UniqueID = NPL.UCID;
				NewPlayer.PlayerName = NPL.PName;
				NewPlayer.PlayerType = (clsPlayer.enuPType)NPL.PType;
				NewPlayer.SkinName = NPL.SName;
				NewPlayer.Tyre_FL = NPL.Tyre_FL;
				NewPlayer.Tyre_FR = NPL.Tyre_FR;
				NewPlayer.Tyre_RL = NPL.Tyre_RL;
                NewPlayer.Tyre_RR = NPL.Tyre_RR;
                Connections[GetConnIdx(NPL.UCID)].PlayerID = NPL.PLID;

				Players.Add(NewPlayer);
			}

			return false;
		}
        public static void rebuildConnListsForDbPurposesONLY()
        {
            /*for (int i = 0; i < Connections.Count; i++)
            {
                byte currUniqueId = Connections[i].UniqueID;
                try
                {
                    Connections.Remove(Connections[i]);
                    InSim.Send_MTC_MessageToConnection("^3 ^1Your record has been destroyed from the connections list.", currUniqueId, 0);
                }
                catch
                {
                    InSim.Send_MST_Message("/msg ^1 Critical error: Conn. record n" + currUniqueId + " could not be destroyed!");
                    InSim.Send_MST_Message("/msg ^1 Please report this issue to the forums!");
                    InSim.Send_MST_Message("/msg ^3 ^7Forum address: http://thcforums.co.cc");
                    InSim.Send_MST_Message("/msg ^1 InSim application termination confirmed!");
                    try
                    {
                        globalVars.dbBlockOutgoing = true;
                        InSim.Send_MST_Message("/msg ^3 ^7Attempting to turn another instance of the application!");
                        Process.Start(Application.ExecutablePath);
                        InSim.Send_MST_Message("/msg ^1------------------------");
                    }
                    finally
                    {
                        Process.GetCurrentProcess().Kill();
                    }
                }
            }*/
            InSim.Request_NCN_AllConnections(30);
            globalVars.dbBlockOutgoing = false;
        }

		/// <summary>
		/// Returns an index value for Connections[] that corresponds with the UniqueID of a connection
		/// </summary>
		/// <param name="UNID">UCID to find</param>
		static public int GetConnIdx(int UNID)
		{
			for (int i = 0; i < Connections.Count; i++)
			{
				if (Connections[i].UniqueID == UNID) { return i; }
			}
			return 0;
		}

		/// <summary>
		/// Returns an index value for Players[] that corresponds with the UniqueID of a player
		/// </summary>
		/// <param name="PLID">PLID to find</param>
        static public int GetPlyIdx(int PLID)
		{
			for (int i = 0; i < Players.Count; i++)
			{
				if (Players[i].PlayerID == PLID) { return i; }
			}
			return 0;
		}

		/// <summary>Returns true if method needs invoking due to threading</summary>
		private bool DoInvoke()
		{
			foreach (Control c in this.Controls)
			{
				if (c.InvokeRequired) return true;
				break;	// 1 control is enough
			}
			return false;
		}

		#endregion

		#region ' Packet receive events '

		// Player chat and system messages.
        private void MSO_MessageOut(Packets.IS_MSO MSO)
        {
            try
            {
                // Invoke method due to threading. Add this line to any receive event before updating the GUI. Just like in this example, you only have to add a new delegate with the right packet parameter and adjust this line in the new method.
                if (DoInvoke()) { object p = MSO; this.Invoke(new dlgMSO(MSO_MessageOut), p); return; }

                textBox1.Text = MSO.Msg + "\r\n" + textBox1.Text;

                string Msg = MSO.Msg.Substring(MSO.TextStart, (MSO.Msg.Length - MSO.TextStart)).ToLower();
                string[] StrMsg = Msg.Split(' ');

                #region InSim commands
                switch (StrMsg[0])
                {
                    case "!h":
                    case "!he":
                    case "!hel":
                    case "!hlp":
                    case "!hlep":
                    case "!hepl":
                    case "!ehlp":
                    case "!ehpl":
                    case "!help":
                        InSim.Send_MTC_MessageToConnection("^3 ^7-OsT- ^3Systems ^7command list [Racing]:", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!rs ^7- Set race settings for next race [Only if you won]", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!points ^7- Shows the amount of points you have won", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!pos ^7- Shows your position in the ranking system", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!laps ^7- Shows the amount of laps you have made", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!cars ^7- Shows a list of allowed cars for next race", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!track ^7- Shows the shortened name of the current track", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!save ^7- Saves your stats to the database", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!vote red ^7- Vote for red flag (race restart)", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!disconnect ^7- Shows if it is safe to disconnect", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!top10 ^7- Shows the top 10 list", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^6!help ; !hlp ; !h ^7- Shows this command list", MSO.UCID, 0);
                        break;

                    case "!top10":
                        misc.saveAllUsers();
                        globalStructs.topTenStrings top10 = dbProcess.getTopTenStringsBy("points_bronze");
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^7Top^210 ^7Players of -OsR-:", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top1, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top2, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top3, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top4, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top5, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top6, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top7, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top8, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top9, MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 " + top10.top10, MSO.UCID, 0);
                        break;

                    case "!p":
                    case "!pos":
                    case "!position":
                        if (StrMsg.Length > 1)
                        {
                            string Username = Msg.Remove(0, StrMsg[0].Length + 1);
                            if (dbProcess.userExists(Username) == true)
                            {
                                misc.saveAllUsers();
                                globalStructs.userGetRank userGetRank = dbProcess.userGetRank(Username);
                                string currRank = userGetRank.rank.ToString();
                                if (currRank.EndsWith("4") || currRank.EndsWith("5") || currRank.EndsWith("6") || currRank.EndsWith("7") || currRank.EndsWith("8") || currRank.EndsWith("9") || currRank.EndsWith("0") || currRank.EndsWith("11") || currRank.EndsWith("12") || currRank.EndsWith("13"))
                                {
                                    currRank += "th";
                                }
                                else if (currRank.EndsWith("1"))
                                {
                                    currRank += "st";
                                }
                                else if (currRank.EndsWith("2"))
                                {
                                    currRank += "nd";
                                }
                                else if (currRank.EndsWith("3"))
                                {
                                    currRank += "rd";
                                }

                                InSim.Send_MTC_MessageToConnection("^3 ^7" + userGetRank.nickname + "^7's position is ^6" + currRank + "^7.", MSO.UCID, 0);
                                InSim.Send_MTC_MessageToConnection("^3 ^7From a total of ^6" + dbProcess.usersTotal() + " ^7players.", MSO.UCID, 0);
                                InSim.Send_MTC_MessageToConnection("^3 ^7With a total of ^6" + userGetRank.pointsBronze + " ^7points.", MSO.UCID, 0);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Entry not found: ^6" + Username, MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            misc.saveAllUsers();
                            globalStructs.userGetRank userGetRank = dbProcess.userGetRank(Connections[GetConnIdx(MSO.UCID)].Username);
                            string currRank = userGetRank.rank.ToString();
                            if (currRank.EndsWith("4") || currRank.EndsWith("5") || currRank.EndsWith("6") || currRank.EndsWith("7") || currRank.EndsWith("8") || currRank.EndsWith("9") || currRank.EndsWith("0") || currRank.EndsWith("11") || currRank.EndsWith("12") || currRank.EndsWith("13"))
                            {
                                currRank += "th";
                            }
                            else if (currRank.EndsWith("1"))
                            {
                                currRank += "st";
                            }
                            else if (currRank.EndsWith("2"))
                            {
                                currRank += "nd";
                            }
                            else if (currRank.EndsWith("3"))
                            {
                                currRank += "rd";
                            }

                            InSim.Send_MTC_MessageToConnection("^3 ^7Your position is ^6" + currRank + "^7.", MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3 ^7From a total of ^6" + dbProcess.usersTotal() + " ^7players.", MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3 ^7With a total of ^6" + userGetRank.pointsBronze + " ^7points.", MSO.UCID, 0);
                        }
                        break;

                    case "!textmatrixindex":
                    case "!tmi":
                        InSim.Send_MTC_MessageToConnection("^3^7 Result: ^3" + misc.matrixIndexSerialNumber(int.Parse(StrMsg[1]), StrMsg[2], false), MSO.UCID, 0);
                        break;

                    case "!testallowedcarsstring":
                    case "!tacs":
                        string carsString1 = cars.getAllowedCarsString(StrMsg[1]);
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        if (carsString1.Split(' ').Length < 11)
                        {
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString1, MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString1.Remove(43), MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString1.Remove(0, 44), MSO.UCID, 0);
                        }
                        break;

                    case "!testmatrixadd":
                    case "!tma":
                        InSim.Send_MTC_MessageToConnection("^3^7 Result: ^3" + misc.matrixAdd(int.Parse(StrMsg[1]), StrMsg[2]), MSO.UCID, 0);
                        break;

                    case "!testmatrixdel":
                    case "!tmd":
                        InSim.Send_MTC_MessageToConnection("^3^7 Result: ^3" + misc.matrixDel(int.Parse(StrMsg[1]), StrMsg[2]), MSO.UCID, 0);
                        break;

                    case "!testmatrixnotnull":
                    case "!tmnn":
                        InSim.Send_MTC_MessageToConnection("^3^7 Result: ^3" + misc.matrixIsNotZero(int.Parse(StrMsg[1]), StrMsg[2]), MSO.UCID, 0);
                        break;

                    case "!cars":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1 && StrMsg.Length > 1)
                        {
                            if (StrMsg[1].StartsWith("d"))
                            {
                                globalVars.allowedCarsTemp = misc.matrixDel(cars.getCarNumber(StrMsg[2]), globalVars.allowedCarsTemp);
                            }
                            else if (StrMsg[1].StartsWith("a"))
                            {
                                globalVars.allowedCarsTemp = misc.matrixAdd(cars.getCarNumber(StrMsg[2]), globalVars.allowedCarsTemp);
                            }
                            else if (StrMsg[1].StartsWith("p"))
                            {
                                if (StrMsg[1].Contains("d") == true)
                                {
                                    globalVars.allowedCarsServer = misc.matrixDel(cars.getCarNumber(StrMsg[2]), globalVars.allowedCarsServer);
                                }
                                else if (StrMsg[1].Contains("a") == true)
                                {
                                    globalVars.allowedCarsServer = misc.matrixAdd(cars.getCarNumber(StrMsg[2]), globalVars.allowedCarsServer);
                                }
                            }
                            else if (StrMsg[1].StartsWith("l"))
                            {
                                globalVars.allowLastRaceCar = Convert.ToBoolean(StrMsg[2]);
                            }
                            else if (StrMsg[1].StartsWith("f"))
                            {
                                if (StrMsg[1].Contains("s") == true)
                                {
                                    globalVars.allowedCarsServer = StrMsg[2];
                                }
                                else if (StrMsg[1].Contains("t") == true)
                                {
                                    globalVars.allowedCarsTemp = StrMsg[2];
                                }
                            }
                        }
                        string carsString2 = cars.getCurrentlyAllowedServerCars();
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        if (carsString2.Split(' ').Length < 11)
                        {
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString2, MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString2.Remove(43), MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3^7 Cars: ^3" + carsString2.Remove(0, 44), MSO.UCID, 0);
                        }
                        InSim.Send_MTC_MessageToConnection("^3^7 Last race car allowed: ^3" + globalVars.allowLastRaceCar, MSO.UCID, 0);
                        break;

                    case "!disconnect":
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        if (dbProcess.userUpdateStats(Connections[GetConnIdx(MSO.UCID)]) == true)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7It is now safe to disconnect from the server.", MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3 ^7Thank you for racing in OsR! Hope to see you back soon! ;]", MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^1Warning: ^7Disconnecting now may be dangerous for your stats!", MSO.UCID, 0);
                        }
                        break;

                    case "!track":
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^7Current track: ^2" + globalVars.currentTrack, MSO.UCID, 0);
                        break;

                    case "!points":
                        bool noPts = true;
                        if (StrMsg.Length > 1 && Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Username.ToLower() == Msg.Remove(0, StrMsg[0].Length + 1) && C.Username != Connections[GetConnIdx(MSO.UCID)].Username)
                                {
                                    InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + "^7's stats:", MSO.UCID, 0);
                                    if (Connections[GetConnIdx(MSO.UCID)].pointsBronze > 0)
                                    {
                                        noPts = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Bronze points: ^2" + C.pointsBronze, MSO.UCID, 0);
                                    }
                                    if (Connections[GetConnIdx(MSO.UCID)].pointsSilver > 0)
                                    {
                                        noPts = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Silver points: ^2" + C.pointsBronze, MSO.UCID, 0);
                                    }
                                    if (Connections[GetConnIdx(MSO.UCID)].pointsGold > 0)
                                    {
                                        noPts = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Gold points: ^2" + C.pointsBronze, MSO.UCID, 0);
                                    }
                                    if (Connections[GetConnIdx(MSO.UCID)].pointsPlatinum > 0)
                                    {
                                        noPts = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Platinum points: ^2" + C.pointsBronze, MSO.UCID, 0);
                                    }
                                    if (Connections[GetConnIdx(MSO.UCID)].pointsGlobal > 0)
                                    {
                                        noPts = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Global points: ^2" + C.pointsBronze, MSO.UCID, 0);
                                    }
                                    if (noPts == true)
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + " ^7 doesn't have any points.", MSO.UCID, 0);
                                    }
                                    return;
                                }
                            }
                        }
                        InSim.Send_MTC_MessageToConnection("^3 ^7Personal stats:", MSO.UCID, 0);
                        if (Connections[GetConnIdx(MSO.UCID)].pointsBronze > 0)
                        {
                            noPts = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Bronze points: ^2" + Connections[GetConnIdx(MSO.UCID)].pointsBronze, MSO.UCID, 0);
                        }
                        if (Connections[GetConnIdx(MSO.UCID)].pointsSilver > 0)
                        {
                            noPts = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Silver points: ^2" + Connections[GetConnIdx(MSO.UCID)].pointsBronze, MSO.UCID, 0);
                        }
                        if (Connections[GetConnIdx(MSO.UCID)].pointsGold > 0)
                        {
                            noPts = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Gold points: ^2" + Connections[GetConnIdx(MSO.UCID)].pointsBronze, MSO.UCID, 0);
                        }
                        if (Connections[GetConnIdx(MSO.UCID)].pointsPlatinum > 0)
                        {
                            noPts = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Platinum points: ^2" + Connections[GetConnIdx(MSO.UCID)].pointsBronze, MSO.UCID, 0);
                        }
                        if (Connections[GetConnIdx(MSO.UCID)].pointsGlobal > 0)
                        {
                            noPts = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Global points: ^2" + Connections[GetConnIdx(MSO.UCID)].pointsBronze, MSO.UCID, 0);
                        }
                        if (noPts == true)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7You don't have any points. Get racing! ;)", MSO.UCID, 0);
                        }
                        break;

                    case "!cl":
                    case "!currlap":
                    case "!currentlap":
                        InSim.Send_MTC_MessageToConnection("^3 ^7Server information:", MSO.UCID, 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^7Current lap: ^2" + globalVars.currentRaceCurrentLap, MSO.UCID, 0);
                        break;

                    case "!laps":
                        bool noLaps = true;
                        if (StrMsg.Length > 1 && Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Username.ToLower() == Msg.Remove(0, StrMsg[0].Length + 1) && C.Username != Connections[GetConnIdx(MSO.UCID)].Username)
                                {
                                    InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + "^7's stats:", MSO.UCID, 0);
                                    if (Connections[GetConnIdx(MSO.UCID)].lapsSum > 0)
                                    {
                                        noLaps = false;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Total laps: ^2" + C.lapsSum, MSO.UCID, 0);
                                    }
                                    if (noLaps == true)
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + " ^7 hasn't driven any laps.", MSO.UCID, 0);
                                    }
                                    return;
                                }
                            }
                        }
                        InSim.Send_MTC_MessageToConnection("^3 ^7Personal stats:", MSO.UCID, 0);
                        if (Connections[GetConnIdx(MSO.UCID)].lapsSum > 0)
                        {
                            noLaps = false;
                            InSim.Send_MTC_MessageToConnection("^3 ^7Total laps: ^2" + Connections[GetConnIdx(MSO.UCID)].lapsSum, MSO.UCID, 0);
                        }
                        if (noLaps == true)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7You haven't made any laps yet. Get racing! ;)", MSO.UCID, 0);
                        }
                        break;

                    case "!save":
                        if (StrMsg.Length > 1 && Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Username.ToLower() == Msg.Remove(0, StrMsg[0].Length + 1) && C.Username != Connections[GetConnIdx(MSO.UCID)].Username)
                                {
                                    if (dbProcess.userUpdateStats(C) == true)
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + "^7's stats have been saved.", MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + Connections[GetConnIdx(MSO.UCID)].PlayerName + "^7 saved your stats.", C.UniqueID, 0);
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^1Error: ^7" + C.PlayerName + "^7's stats could not be saved.", MSO.UCID, 0);
                                    }
                                }
                            }
                        }
                        if (dbProcess.userUpdateStats(Connections[GetConnIdx(MSO.UCID)]) == true)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7Your stats have been saved.", MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^1Error: ^7Your stats could not be saved.", MSO.UCID, 0);
                        }
                        break;

                    case "!saveall":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Username != Connections[GetConnIdx(MSO.UCID)].Username)
                                {
                                    if (dbProcess.userUpdateStats(C) == true)
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + C.PlayerName + "^7's stats have been saved.", MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("^3 ^7" + Connections[GetConnIdx(MSO.UCID)].PlayerName + "^7 saved your stats.", C.UniqueID, 0);
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^1Error: ^7" + C.PlayerName + "^7's stats could not be saved.", MSO.UCID, 0);
                                    }
                                }
                                else
                                {
                                    if (dbProcess.userUpdateStats(Connections[GetConnIdx(MSO.UCID)]) == true)
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Your stats have been saved.", MSO.UCID, 0);
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^1Error: ^7Your stats could not be saved.", MSO.UCID, 0);
                                    }
                                }
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!givepts":
                    case "!gp":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            if (StrMsg.Length > 3)
                            {
                                foreach (clsConnection C in Connections)
                                {
                                    if (C.Username.ToLower() == StrMsg[3].Trim())
                                    {
                                        if (StrMsg[1].StartsWith("b"))
                                        {
                                            Connections[GetConnIdx(C.UniqueID)].pointsBronze += int.Parse(StrMsg[2]);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7" + StrMsg[2] + "BR pts given to " + C.PlayerName + "^7.", MSO.UCID, 0);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You received " + StrMsg[2] + "BRONZE pts.", C.UniqueID, 0);
                                        }
                                        else if (StrMsg[1].StartsWith("s"))
                                        {
                                            Connections[GetConnIdx(C.UniqueID)].pointsSilver += int.Parse(StrMsg[2]);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7" + StrMsg[2] + "SI pts given to " + C.PlayerName + "^7.", MSO.UCID, 0);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You received " + StrMsg[2] + "SILVER pts.", C.UniqueID, 0);
                                        }
                                        else if (StrMsg[1].StartsWith("go"))
                                        {
                                            Connections[GetConnIdx(C.UniqueID)].pointsGold += int.Parse(StrMsg[2]);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7" + StrMsg[2] + "GO pts given to " + C.PlayerName + "^7.", MSO.UCID, 0);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You received " + StrMsg[2] + "GOLD pts.", C.UniqueID, 0);
                                        }
                                        else if (StrMsg[1].StartsWith("p"))
                                        {
                                            Connections[GetConnIdx(C.UniqueID)].pointsPlatinum += int.Parse(StrMsg[2]);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7" + StrMsg[2] + "PL pts given to " + C.PlayerName + "^7.", MSO.UCID, 0);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You received " + StrMsg[2] + "PLATINUM pts.", C.UniqueID, 0);
                                        }
                                        else if (StrMsg[1].StartsWith("gl"))
                                        {
                                            Connections[GetConnIdx(C.UniqueID)].pointsGlobal += int.Parse(StrMsg[2]);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7" + StrMsg[2] + "GL pts given to " + C.PlayerName + "^7.", MSO.UCID, 0);
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You received " + StrMsg[2] + "GLOBAL pts.", C.UniqueID, 0);
                                        }
                                        return;
                                    }
                                }
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("This command needs 3 parameters", MSO.UCID, 0);
                                return;
                            }
                            InSim.Send_MTC_MessageToConnection("The user was not found online", MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("Entered: " + StrMsg[3].Trim(), MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!sw":
                    case "!setwinner":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            if (StrMsg.Length > 1)
                            {
                                foreach (clsConnection C in Connections)
                                {
                                    if (C.Username.ToLower() == Msg.Remove(0, StrMsg[0].Length + 1))
                                    {
                                        winnerUCID = C.UniqueID;
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Winner changed to: " + C.PlayerName, MSO.UCID, 0);
                                        return;
                                    }
                                }
                                InSim.Send_MTC_MessageToConnection("The user was not found online", MSO.UCID, 0);
                                InSim.Send_MTC_MessageToConnection("Entered: " + Msg.Remove(0, StrMsg[0].Length + 1), MSO.UCID, 0);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!rs":
                    case "!racesettings":
                        if (MSO.UCID == winnerUCID)
                        {
                            if (raceStarted == false && winnerSet == true)
                            {
                                buttonSequence.createSequence("race settings", MSO.UCID, Connections[GetConnIdx(MSO.UCID)]);
                                buttonSequence.createSequence("HUD", 255, null);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("Command locked", MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unauthorized access", MSO.UCID, 0);
                        }
                        break;

                    case "!sr":
                    case "!reason":
                    case "!setreason":
                        if (StrMsg.Length > 1)
                        {
                            Connections[GetConnIdx(MSO.UCID)].settedReason = Msg.Remove(0, StrMsg[0].Length + 1);
                            InSim.Send_MTC_MessageToConnection("^3 ^2Reason set. You may now execute the command you want. ;)", MSO.UCID, 0);
                            InSim.Send_MTC_MessageToConnection("^3 ^7Reason: " + Connections[GetConnIdx(MSO.UCID)].settedReason, MSO.UCID, 0);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                        }
                        break;

                    case "!frs":
                    case "!forceracesettings":
                        if (Connections[GetConnIdx(MSO.UCID)].Username == "broken" || Connections[GetConnIdx(MSO.UCID)].Username == "Mikjen" || Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            buttonSequence.createSequence("race settings", MSO.UCID, Connections[GetConnIdx(MSO.UCID)]);
                            buttonSequence.createSequence("HUD", 255, null);
                            Connections[GetConnIdx(MSO.UCID)].Action = "setting race details";
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!csp":
                    case "!checkstartpenalty":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            if (StrMsg.Length > 1)
                            {
                                foreach (clsConnection C in Connections)
                                {
                                    if (C.Username.ToLower() == Msg.Remove(0, StrMsg[0].Length + 1))
                                    {
                                        InSim.Send_MTC_MessageToConnection("User start penalty: " + C.startPenalty, MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("/p_" + C.startPenalty + " " + C.Username, MSO.UCID, 0);
                                        return;
                                    }
                                }
                                InSim.Send_MTC_MessageToConnection("The user was not found online", MSO.UCID, 0);
                                InSim.Send_MTC_MessageToConnection("Entered: " + Msg.Remove(0, StrMsg[0].Length + StrMsg[1].Length + 2), MSO.UCID, 0);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!vote":
                        if (StrMsg.Length > 1)
                        {
                            bool voteAllowed = false;
                            string[] StrUsr = voteVoters.Split('|');
                            for (int suc = 0; suc < StrUsr.Length; suc++)
                            {
                                if (StrUsr[suc] == Connections[GetConnIdx(MSO.UCID)].Username)
                                {
                                    InSim.Send_MTC_MessageToConnection("^3 ^7Can not vote for same thing twice.", MSO.UCID, 0);
                                    return;
                                }
                            }
                            switch (StrMsg[1])
                            {
                                case "red":
                                    if (voteVote == "" || voteVote == "red")
                                    {
                                        if (Connections[GetConnIdx(MSO.UCID)].PlayerID != 0)
                                        {
                                            if (winnerSet == false)
                                            {
                                                voteIdleTime = 30;
                                                voteVote = "red";
                                                voteVotes += 1;
                                                InSim.Send_MST_Message("/msg ^3 " + Connections[GetConnIdx(MSO.UCID)].PlayerName + " ^8voted for red flag.");
                                                voteAllowed = true;
                                                voteVoters += "|" + Connections[GetConnIdx(MSO.UCID)].Username;
                                            }
                                            else
                                            {
                                                InSim.Send_MTC_MessageToConnection("^3 ^7Can not vote for red flag while next car is being chosen. ....", MSO.UCID, 0);
                                            }
                                        }
                                        else
                                        {
                                            InSim.Send_MTC_MessageToConnection("^3 ^7You are not in the race to vote for red flag.", MSO.UCID, 0);
                                        }
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Can not call 2 votes at a time. Sorry.", MSO.UCID, 0);
                                    }
                                    break;

                                default:
                                    if (StrMsg[0].StartsWith("!"))
                                    {
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Vote option not recognized.", MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("^3 ^7Entered: " + Msg.Remove(0, StrMsg[0].Length + 1), MSO.UCID, 0);
                                    }
                                    break;
                            }
                            if (voteAllowed == true)
                            {
                                int currPlayers = 0;
                                foreach (clsPlayer P in Players)
                                {
                                    currPlayers += 1;
                                }
                                if (currPlayers > 2)
                                {
                                    InSim.Send_MST_Message("/msg ^3 ^7Votes: " + voteVotes + " / " + (currPlayers * 3 / 4));
                                    if (voteVotes >= currPlayers * 3 / 4 && voteVotes > 1)
                                    {
                                        InSim.Send_MST_Message("/msg ^3 ^7Vote completed!");
                                        switch (voteVote)
                                        {
                                            case "red":
                                                InSim.Send_MST_Message("/rcm ^1RED FLAG");
                                                InSim.Send_MST_Message("/rcm_all");
                                                InSim.Send_MST_Message("/msg ^1RED FLAG");
                                                InSim.Send_MST_Message("/restart");
                                                break;
                                        }
                                        voteIdleTime = 255;
                                        voteExpired = false;
                                        voteVote = "";
                                        voteVoters = "";
                                        voteVotes = 0;
                                    }
                                }
                                else if (currPlayers == 2)
                                {
                                    InSim.Send_MST_Message("/msg ^3 ^7Votes: " + voteVotes + " / 2");
                                    if (voteVotes >= 2)
                                    {
                                        InSim.Send_MST_Message("/msg ^3 ^7Vote completed!");
                                        switch (voteVote)
                                        {
                                            case "red":
                                                InSim.Send_MST_Message("/rcm ^1RED FLAG");
                                                InSim.Send_MST_Message("/rcm_all");
                                                InSim.Send_MST_Message("/msg ^1RED FLAG");
                                                InSim.Send_MST_Message("/restart");
                                                break;
                                        }
                                        voteIdleTime = 255;
                                        voteExpired = false;
                                        voteVote = "";
                                        voteVoters = "";
                                        voteVotes = 0;
                                    }
                                }
                                else if (currPlayers == 1)
                                {
                                    InSim.Send_MST_Message("/msg ^3 ^7Votes: " + voteVotes + " / 1");
                                    if (voteVotes >= 1)
                                    {
                                        InSim.Send_MST_Message("/msg ^3 ^7Vote completed!");
                                        switch (voteVote)
                                        {
                                            case "red":
                                                InSim.Send_MST_Message("/rcm ^1RED FLAG");
                                                InSim.Send_MST_Message("/rcm_all");
                                                InSim.Send_MST_Message("/msg ^1RED FLAG");
                                                InSim.Send_MST_Message("/restart");
                                                break;
                                        }
                                        voteIdleTime = 255;
                                        voteExpired = false;
                                        voteVote = "";
                                        voteVoters = "";
                                        voteVotes = 0;
                                    }
                                }
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                        }
                        break;

                    case "!pnos":
                    case "!penaltyonstart":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            if (Connections[GetConnIdx(MSO.UCID)].settedReason != null && Connections[GetConnIdx(MSO.UCID)].settedReason != "")
                            {
                                if (StrMsg.Length > 1)
                                {
                                    if (StrMsg[1] == "dt" || StrMsg[1] == "sg" || StrMsg[1] == "30" || StrMsg[1] == "45")
                                    {
                                        foreach (clsConnection C in Connections)
                                        {
                                            if (C.Username.ToLower() == Msg.Remove(0, (StrMsg[0] + StrMsg[1]).Length + 1))
                                            {
                                                InSim.Send_MST_Message("/msg -                            -");
                                                InSim.Send_MST_Message("/msg ^3 ^7Action: ^1Race start penalty assignment:");
                                                InSim.Send_MST_Message("/msg ^3 ^7Executor: ^7" + Connections[GetConnIdx(MSO.UCID)].PlayerName);
                                                InSim.Send_MST_Message("/msg ^3 ^7Player: ^9" + C.PlayerName + "^7.");
                                                InSim.Send_MST_Message("/msg ^3 ^7Reason: ^7" + Connections[GetConnIdx(MSO.UCID)].settedReason);
                                                InSim.Send_MST_Message("/msg -                            -");
                                                C.startPenalty = StrMsg[1];
                                                return;
                                            }
                                        }
                                        InSim.Send_MTC_MessageToConnection("The user was not found online", MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("Entered: " + Msg.Remove(0, StrMsg[0].Length + StrMsg[1].Length + 2), MSO.UCID, 0);
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("Parameter is not valid", MSO.UCID, 0);
                                    }
                                }
                                else
                                {
                                    InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                                }
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Please specify a reason.", MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!ap":
                    case "!applypenalty":
                        if (Connections[GetConnIdx(MSO.UCID)].IsAdmin == 1)
                        {
                            if (Connections[GetConnIdx(MSO.UCID)].settedReason != null && Connections[GetConnIdx(MSO.UCID)].settedReason != "")
                            {
                                if (StrMsg.Length > 1)
                                {
                                    if (StrMsg[1] == "dt" || StrMsg[1] == "sg" || StrMsg[1] == "30" || StrMsg[1] == "45")
                                    {
                                        foreach (clsConnection C in Connections)
                                        {
                                            if (C.Username.ToLower() == Msg.Remove(0, (StrMsg[0] + StrMsg[1]).Length + 1))
                                            {
                                                InSim.Send_MST_Message("/msg -                            -");
                                                InSim.Send_MST_Message("/msg ^3 ^7Action: ^1Penalty assignment:");
                                                InSim.Send_MST_Message("/msg ^3 ^7Executor: ^7" + Connections[GetConnIdx(MSO.UCID)].PlayerName);
                                                InSim.Send_MST_Message("/msg ^3 ^7Player: ^9" + C.PlayerName + "^7.");
                                                InSim.Send_MST_Message("/msg ^3 ^7Reason: ^7" + Connections[GetConnIdx(MSO.UCID)].settedReason);
                                                InSim.Send_MST_Message("/msg -                            -");
                                                InSim.Send_MST_Message("/p_" + StrMsg[1] + " " + C.Username);
                                                return;
                                            }
                                        }
                                        InSim.Send_MTC_MessageToConnection("The user was not found online", MSO.UCID, 0);
                                        InSim.Send_MTC_MessageToConnection("Entered: " + Msg.Remove(0, StrMsg[0].Length + StrMsg[1].Length + 2), MSO.UCID, 0);
                                    }
                                    else
                                    {
                                        InSim.Send_MTC_MessageToConnection("Parameter is not valid", MSO.UCID, 0);
                                    }
                                }
                                else
                                {
                                    InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                                }
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Please specify a reason.", MSO.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;

                    case "!cbs":
                    case "!callbuttonsequence":
                        if (StrMsg.Length > 1)
                        {
                            buttonSequence.createSequence(Msg.Remove(0, StrMsg[0].Length + 1), MSO.UCID, Connections[GetConnIdx(MSO.UCID)]);
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("This command needs a parameter", MSO.UCID, 0);
                        }
                        break;

                    default:
                        if (StrMsg[0].StartsWith("!"))
                        {
                            InSim.Send_MTC_MessageToConnection("Unknown command", MSO.UCID, 0);
                        }
                        break;
                }
                #endregion
            }
            catch (Exception E)
            {
                string[] addInf = ("MSO.Msg = " + MSO.Msg + "|" + "MSO.PLID = " + MSO.PLID + "|" + "MSO.TextStart = " + MSO.TextStart + "|" + "MSO.UserType = " + MSO.UserType).Split('|');
                misc.buildErrorReportOnCrash(E, "MSO-TWR(UNN)", "MSO(UNN)", addInf, Connections[GetConnIdx(MSO.UCID)].Username);
            }
        }

		// A new client joined the server.
		private void NCN_ClientJoinsHost(Packets.IS_NCN NCN)
        {
            InSim.Send_MTC_MessageToConnection("^3 ^7Welcome to -OsT- Servers. Have fun and keep it clean. :)", NCN.UCID, 0);
            try
            {
                AddToConnectionsList(NCN);	// Update Connections[] list
            }
            catch (Exception E)
            {
                InSim.Send_MTC_MessageToConnection("^3 ^7A problem has occured on your account.", NCN.UCID, 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry, but you can't stay in the server at this point.", NCN.UCID, 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7A report of this case will be sent to all administrators.", NCN.UCID, 0);
                misc.buildErrorReportOnCrash(E, "Major account issue", "NCN(ATCL)", ("AddToConnectionsList(NCN) failure|User kicked").Split('|'), NCN.UName);
                InSim.Send_MST_Message("/kick " + NCN.UName);
            }
            try
            {
                if (dbProcess.userExists(Connections[GetConnIdx(NCN.UCID)].Username) == false)
                {
                    if (dbProcess.userRegister(Connections[GetConnIdx(NCN.UCID)]) == true)
                    {
                        InSim.Send_MST_Message("/msg ^3 ^7New community member: " + Connections[GetConnIdx(NCN.UCID)].PlayerName);
                    }
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "Account check/register issue", "NCN(UE&UR)", ("userExists and/or userRegister failue").Split('|'), NCN.UName);
            }

            if (NCN.ReqI != 30)
            {
                if (Connections[GetConnIdx(NCN.UCID)].statsLoadedSuccessfully == false)
                {
                    dbProcess.userAddStats(Connections[GetConnIdx(NCN.UCID)]);
                }
                else
                {
                    dbProcess.userGetStats(Connections[GetConnIdx(NCN.UCID)]);
                }
            }
            else
            {
                if (Connections[GetConnIdx(NCN.UCID)].statsLoadedSuccessfully == false)
                {
                    dbProcess.userAddStats(Connections[GetConnIdx(NCN.UCID)]);
                }
            }

            buttonSequence.createSequence("HUD", NCN.UCID, null);

            // Your code here

            if (dbProcess.dbConnectCheck() == false)
            {
                InSim.Send_MTC_MessageToConnection("^3 ^1STATE CHECK:", NCN.UCID, 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7The stats system is currently down.", NCN.UCID, 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7The stats you build may be lost.", NCN.UCID, 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry for the inconvenience.", NCN.UCID, 0);
            }
		}

		// A client left the server.
		private void CNL_ClientLeavesHost(Packets.IS_CNL CNL)
        {
            dbProcess.userUpdateStats(Connections[GetConnIdx(CNL.UCID)]);
            if (CNL.Reason == Enums.CNL_Reason.LEAVR_DISCO)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8disconnected (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_KICKED)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8was kicked (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_BANNED)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8was banned (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_LOSTCONN)
            {
                InSim.Send_MST_Message("/msg Lost connection to " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8(" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_TIMEOUT)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8timed out (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_SECURITY)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8didn't fulfil the security requirements");
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8was kicked (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }
            else if (CNL.Reason == Enums.CNL_Reason.LEAVR_NUM)
            {
                InSim.Send_MST_Message("/msg " + Connections[GetConnIdx(CNL.UCID)].PlayerName + " ^8left(NUM) (" + Connections[GetConnIdx(CNL.UCID)].Username + ")");
            }

			RemoveFromConnectionsList(CNL.UCID);		// Update Connections[] list
            if (winnerUCID == CNL.UCID)
            {
                InSim.Send_MST_Message("/msg ^3 ^7Race winner left! Picking random person as winner.");
                if (Connections.Count > 1)
                {
                    int randNum = misc.getRandNum(1, Connections.Count - 1);

                    winnerUCID = Connections[randNum].UniqueID;
                    InSim.Send_MST_Message("/msg ^3 ^7Chosen player: " + Connections[randNum].PlayerName);
                    return;
                }
                InSim.Send_MST_Message("/msg ^3 ^1Error! ^7No player picked! Restarting race!");
                InSim.Send_MST_Message("/restart");
            }
		}

		// A client changed name or plate.
		private void CPR_ClientRenames(Packets.IS_CPR CPR)
		{
			foreach (clsConnection c in Connections)	// Update Connections[] list
				if (c.UniqueID == CPR.UCID)
				{
					c.PlayerName = CPR.PName;
				}
			foreach (clsPlayer p in Players)	// Update Players[] list
				if (p.UniqueID == CPR.UCID)
				{
					p.PlayerName = CPR.PName;
					p.Plate = CPR.Plate;
				}
		}

		// Car was taken over by an other player
		private void TOC_PlayerCarTakeOver(Packets.IS_TOC TOC)
        {
            Players[GetPlyIdx(Connections[GetConnIdx(TOC.OldUCID)].PlayerID)].UniqueID = TOC.NewUCID;	     // Update Players[] list
            Players[GetPlyIdx(Connections[GetConnIdx(TOC.OldUCID)].PlayerID)].PlayerID = TOC.PLID;	         // Update Players[] list
            //MY CODE :::>
            Connections[GetConnIdx(TOC.OldUCID)].PlayerID = TOC.PLID;                                        // Update Connections[] list

            // Your code here
		}

		// A player leaves the race (spectate)
		private void PLL_PlayerLeavesRace(Packets.IS_PLL PLL)
		{
            if (raceStarted == true)
            {
                if (globalVars.currentRaceCurrentLap > 1 && misc.convertToConnection(Players[GetPlyIdx(PLL.PLID)]).authorizedStart == true)
                {
                    Connections[GetConnIdx(Players[GetPlyIdx(PLL.PLID)].UniqueID)].racesUnfinished += 1;
                }
                else
                {
                    globalVars.currentRaceRacersCount -= 1;
                }
            }
            Connections[GetConnIdx(Players[GetPlyIdx(PLL.PLID)].UniqueID)].specSum += 1;
            RemoveFromPlayersList(PLL.PLID);		// Update Players[] list

			// Your code here
            if (Players.Count == 0)
            {
                globalVars.currentRaceCurrentLap = 1;
            }
		}

		// Player help settings changed.
		private void PFL_PlayerFlagsChanged(Packets.IS_PFL PFL)
		{
		}

		// A player goes to the garage (setup screen).
		private void PLP_PlayerGoesToGarage(Packets.IS_PLP PLP)
        {
            InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(misc.convertToUCID(PLP.PLID))].Username);
            if (globalVars.currentRaceCurrentLap > 1 && raceStarted == true)
            {
                InSim.Send_MTC_MessageToConnection("^3 ^7Mid-race going to garage is not allowed.", misc.convertToUCID(PLP.PLID), 0);
                InSim.Send_MTC_MessageToConnection("^3 ^7You have lost this race.", misc.convertToUCID(PLP.PLID), 0);
                Connections[GetConnIdx(misc.convertToUCID(PLP.PLID))].authorizedStart = false;
            }
		}

		// A player joins the race. If PLID already exists, then player leaves pit.
		private void NPL_PlayerJoinsRace(Packets.IS_NPL NPL)
		{
            bool LeavesPits = AddToPlayersList(NPL);	// Update Players[] list
            Players[GetPlyIdx(NPL.PLID)].currentLap = 1;

            if (NPL.ReqI == 0)
            {
                Players[GetPlyIdx(NPL.PLID)].safSpecInvinc = true;
            }

            if (raceStarted == true)
            {
                if (globalVars.currentRaceCurrentLap < 2)
                {
                    globalVars.currentRaceRacersCount += 1;
                    Connections[GetConnIdx(NPL.UCID)].authorizedStart = true;
                }
                else
                {
                    InSim.Send_MTC_MessageToConnection("^3 ^7You have joined the race too late.", NPL.UCID, 0);
                    InSim.Send_MTC_MessageToConnection("^3 ^7You will not win any points from this race.", NPL.UCID, 0);
                    Connections[GetConnIdx(NPL.UCID)].authorizedStart = false;
                }
            }
            if (raceStarted == true)
            {
                if (intRestEnabled == true)
                {
                    if (nextRaceIntRest != NPL.H_TRes)
                    {
                        InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry, but intake restriction is set to " + nextRaceIntRest + "%", NPL.UCID, 0);
                        InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(NPL.UCID)].Username);
                    }
                }
                if (addMassEnabled == true)
                {
                    if (nextRaceAddMass != NPL.H_Mass)
                    {
                        InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry, but added mass is set to " + nextRaceAddMass + "kg", NPL.UCID, 0);
                        InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(NPL.UCID)].Username);
                    }
                }
                if (nextCarSet == true)
                {
                    if (NPL.CName != nextRaceCar)
                    {
                        InSim.Send_MST_Message("/cars " + nextRaceCar);
                        InSim.Send_MTC_MessageToConnection("^3 ^7You are supposed to use the race car (" + nextRaceCar + ")", NPL.UCID, 0);
                        InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(NPL.UCID)].Username);
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("^3 ^7Car & settings authorized.", NPL.UCID, 0);
                    }
                }
            }
            else if (winnerUCID == NPL.UCID)
            {
                InSim.Send_MTC_MessageToConnection("^3 ^7Command to select a car: !racesettings or !rs", NPL.UCID, 0);
            }
            if (Connections[GetConnIdx(NPL.UCID)].Action == "setting race details" && raceStarted == false && winnerUCID == NPL.UCID)
            {
                nextRaceCar = Players[GetPlyIdx(NPL.PLID)].CarName;
                nextRaceIntRest = Players[GetPlyIdx(NPL.PLID)].IntakeRestriction;
                nextRaceAddMass = Players[GetPlyIdx(NPL.PLID)].AddedMass;

                buttonSequence.createSequence("race settings", NPL.UCID, Connections[GetConnIdx(NPL.UCID)]);
            }
			// Your code here

            if (Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].startPenaltyApplyNow == true && Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].startPenalty != null && Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].startPenalty != "")
            {
                InSim.Send_MST_Message("/p_" + Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].startPenalty + " " + Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].Username);
                Connections[GetConnIdx(Players[GetPlyIdx(NPL.PLID)].UniqueID)].startPenalty = "";
            }
		}

		// A player crosses start/finish line
		private void LAP_PlayerCompletesLap(Packets.IS_LAP LAP)
		{
            Connections[GetConnIdx(Players[GetPlyIdx(LAP.PLID)].UniqueID)].lapsSum += 1;

            Players[GetPlyIdx(LAP.PLID)].currentLap = LAP.LapsDone + 1;

            ushort currHighestLap = 1;
            foreach (clsPlayer P in Players)
            {
                if (P.currentLap > currHighestLap)
                {
                    currHighestLap = (ushort)P.currentLap;
                }
            }
            globalVars.currentRaceCurrentLap = currHighestLap;
		}

		// A player finishes race and crosses the finish line
		private void FIN_PlayerFinishedRaces(Packets.IS_FIN FIN)
		{
		}

		// A player resets the car
		private void CRS_PlayerResetsCar(Packets.IS_CRS CRS)
        {
            InSim.Send_MST_Message("/msg ^3 ^7Penalty applied for resetting car!");
            InSim.Send_MST_Message("/p_45 " + Connections[GetConnIdx(Players[GetPlyIdx(CRS.PLID)].UniqueID)].Username);
		}

		// A player stops for making a pitstop
		private void PIT_PlayerStopsAtPit(Packets.IS_PIT PIT)
		{
            Connections[GetConnIdx(Players[GetPlyIdx(PIT.PLID)].UniqueID)].pitstopsSum += 1;
		}

		// A pitstop got finished
		private void PSF_PitStopFinished(Packets.IS_PSF PSF)
		{
		}

		// A player hits an autocross object
		private void AXO_PlayerHitsAutocrossObject(Packets.IS_AXO AXO)
		{
		}

		// A player pressed Shift+I or Shift+B
		private void BFN_PlayerRequestsButtons(Packets.IS_BFN BFN)
        {
            buttonSequence.createSequence("HUD", BFN.UCID, null);
		}

		// A player clicked a custom button
		private void BTC_ButtonClicked(Packets.IS_BTC BTC)
		{
            switch (BTC.ClickID)
            {
                case 56:
                    //int rest en/dis
                    if (raceStarted == false || Connections[GetConnIdx(BTC.UCID)].IsAdmin == 1)
                    {
                        intRestEnabled = !intRestEnabled;
                        buttonSequence.createSequence("race settings upd", BTC.UCID, Connections[GetConnIdx(BTC.UCID)]);
                        buttonSequence.createSequence("HUD", 255, null);
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTC.UCID, 0);
                    }
                    break;

                case 59:
                    //add mass en/dis
                    if (raceStarted == false || Connections[GetConnIdx(BTC.UCID)].IsAdmin == 1)
                    {
                        addMassEnabled = !addMassEnabled;
                        buttonSequence.createSequence("race settings upd", BTC.UCID, Connections[GetConnIdx(BTC.UCID)]);
                        buttonSequence.createSequence("HUD", 255, null);
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTC.UCID, 0);
                    }
                    break;

                case 61:
                    //Start race
                    if (raceStarted == false || Connections[GetConnIdx(BTC.UCID)].IsAdmin == 1)
                    {
                        if (nextRaceCar == lastRaceCar && globalVars.allowLastRaceCar == false)
                        {
                            InSim.Send_MST_Message("/msg ^3 ^7Attempt to pick car from previous race. Cancelled!");
                            return;
                        }
                        Connections[GetConnIdx(BTC.UCID)].Action = "nothing";
                        raceResCountdown = true;
                        //timeToResRace = 60;

                        buttonSequence.createSequence("HUD", 255, null);
                        buttonSequence.deleteSequence("race settings", BTC.UCID);
                        InSim.Send_MST_Message("/msg ^3 " + Connections[GetConnIdx(BTC.UCID)].PlayerName + " ^7chose " + nextRaceCar + " for next race.");
                        string NRINR1 = "--";
                        string NRADM1 = "---";
                        if (intRestEnabled == true)
                        {
                            NRINR1 = nextRaceIntRest.ToString();
                        }
                        if (addMassEnabled == true)
                        {
                            NRADM1 = nextRaceAddMass.ToString();
                        }
                        InSim.Send_MST_Message("/msg ^3 ^7Next race: " + nextRaceCar + " | " + NRINR1 + "% | " + NRADM1 + "kg");
                        buttonSequence.createSequence("next race info", 255, null);
                        timeSinceEndOfRace = 255;
                        timerPaused = false;
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTC.UCID, 0);
                    }
                    break;

                case 62:
                    //RANDOM!
                    if (raceStarted == false || Connections[GetConnIdx(BTC.UCID)].IsAdmin == 1)
                    {
                        string addInf0 = "EEE";
                        string addInf1 = "EEE";
                        string addInf2 = "EEE";
                        string addInf3 = "EEE";
                        string addInf4 = "EEE";
                        try
                        {
                            addInf0 = "tempRand1 is no longer valid";
                            addInf1 = "tempRand1 is no longer valid";
                            addInf2 = "Car pick status is no longer valid";
                            addInf3 = "intRestEnabled has not been reached";
                            addInf4 = "addMassEnabled has not been reached";

                            nextRaceCar = cars.getAllowedRandCar();

                            addInf3 = "intRestEnabled = false (no random number pick)";
                            if (intRestEnabled == true)
                            {
                                addInf3 = "intRestEnabled = true (picking number)";
                                nextRaceIntRest = byte.Parse(misc.getRandNum(0, 50).ToString());
                            }
                            addInf4 = "addMassEnabled = false (no random number pick)";
                            if (addMassEnabled == true)
                            {
                                addInf4 = "addMassEnabled = true (picking number)";
                                nextRaceAddMass = byte.Parse(misc.getRandNum(0, cars.maxAddMass(nextRaceCar)).ToString());
                            }
                        }
                        catch (Exception E)
                        {
                            string[] addInf = (addInf0 + "|" + addInf1 + "|" + addInf2 + "|" + addInf3 + "|" + addInf4).Split('|');
                            misc.buildErrorReportOnCrash(E, "RNDBTN-NFI", "RNDBTN", addInf, Connections[GetConnIdx(BTC.UCID)].Username);
                        }

                        try
                        {
                            buttonSequence.createSequence("race settings", BTC.UCID, Connections[GetConnIdx(BTC.UCID)]);
                            buttonSequence.createSequence("HUD", 255, null);
                        }
                        catch (Exception E)
                        {
                            string[] addInf = (addInf0 + "|" + addInf1 + "|" + addInf2 + "|" + addInf3 + "|" + addInf4).Split('|');
                            misc.buildErrorReportOnCrash(E, "RNDBTN-NFI", "RNDBTN", addInf, Connections[GetConnIdx(BTC.UCID)].Username);
                        }
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTC.UCID, 0);
                    }
                    break;

                case 63:
                    //Pause timer
                    if (raceStarted == false)
                    {
                        if (timerPauseLeftTime > 0)
                        {
                            if (timerPaused == false)
                            {
                                raceResCountdown = false;
                                timerPaused = true;

                                buttonSequence.createSequence("HUD", 255, null);
                            }
                            else
                            {
                                timerPaused = false;
                                if (timeSinceEndOfRace == 255)
                                {
                                    raceResCountdown = true;
                                }

                                buttonSequence.createSequence("HUD", 255, null);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3 Pause time elapsed.", BTC.UCID, 0);
                        }
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTC.UCID, 0);
                        buttonSequence.createSequence("race settings pt", BTC.UCID, Connections[GetConnIdx(BTC.UCID)]);
                    }
                    break;

                case 64:
                    //X button on race settings
                    Connections[GetConnIdx(BTC.UCID)].Action = "nothing";
                    buttonSequence.deleteSequence("race settings", BTC.UCID);
                    break;

                case 101:
                    //X button on next race info
                    buttonSequence.deleteSequence("next race info", BTC.UCID);
                    break;
            }
		}

		// A player submitted a custom textbox
		private void BTT_TextBoxOkClicked(Packets.IS_BTT BTT)
		{
            switch (BTT.ClickID)
            {
                case 54:
                    //car change
                    if (raceStarted == false || Connections[GetConnIdx(BTT.UCID)].IsAdmin == 1)
                    {
                        if (cars.carExists(BTT.Text))
                        {
                            if (winnerUCID != lastRaceWinnerUCID || BTT.Text != lastRaceCar || globalVars.allowLastRaceCar == true)
                            {
                                if (cars.carAllowedAdmin(BTT.Text) == true)
                                {
                                    nextRaceCar = BTT.Text.ToUpper();
                                    buttonSequence.createSequence("race settings upd", BTT.UCID, Connections[GetConnIdx(BTT.UCID)]);
                                    buttonSequence.createSequence("HUD", 255, null);
                                }
                                else if (cars.carAllowedAdmin(BTT.Text) == true && Connections[GetConnIdx(BTT.UCID)].IsAdmin == 1)
                                {
                                    InSim.Send_MTC_MessageToConnection("^3 ^7Car ^1not ^7allowed: " + BTT.Text.ToUpper(), BTT.UCID, 0);
                                    nextRaceCar = BTT.Text.ToUpper();
                                    buttonSequence.createSequence("race settings upd", BTT.UCID, Connections[GetConnIdx(BTT.UCID)]);
                                    buttonSequence.createSequence("HUD", 255, null);
                                    InSim.Send_MTC_MessageToConnection("^3 ^7Admin status ^2confirmed^7. Car disallow ^1overrided^7.", BTT.UCID, 0);
                                }
                                else
                                {
                                    InSim.Send_MTC_MessageToConnection("^3 ^7Car ^1not ^7allowed: " + BTT.Text.ToUpper(), BTT.UCID, 0);
                                }
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Last race car (" + BTT.Text.ToUpper() + ") is not allowed.", BTT.UCID, 0);
                            }
                        }
                        else
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7No such car: " + BTT.Text.ToUpper(), BTT.UCID, 0);
                        }
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTT.UCID, 0);
                    }
                    break;

                case 57:
                    //int rest change
                    if (raceStarted == false || Connections[GetConnIdx(BTT.UCID)].IsAdmin == 1)
                    {
                        try
                        {
                            if (byte.Parse(BTT.Text) <= 50)
                            {
                                nextRaceIntRest = byte.Parse(BTT.Text);
                                buttonSequence.createSequence("race settings upd", BTT.UCID, Connections[GetConnIdx(BTT.UCID)]);
                                buttonSequence.createSequence("HUD", 255, null);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Allowed range: 0% - 50%", BTT.UCID, 0);
                            }
                        }
                        catch
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7Allowed range: 0% - 50%", BTT.UCID, 0);
                        }
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTT.UCID, 0);
                    }
                    break;

                case 60:
                    //add mass change
                    if (raceStarted == false || Connections[GetConnIdx(BTT.UCID)].IsAdmin == 1)
                    {
                        try
                        {
                            if (byte.Parse(BTT.Text) <= cars.maxAddMass(nextRaceCar))
                            {
                                nextRaceAddMass = byte.Parse(BTT.Text);
                                buttonSequence.createSequence("race settings upd", BTT.UCID, Connections[GetConnIdx(BTT.UCID)]);
                                buttonSequence.createSequence("HUD", 255, null);
                            }
                            else
                            {
                                InSim.Send_MTC_MessageToConnection("^3 ^7Allowed range: 0kg - " + cars.maxAddMass(nextRaceCar) + "kg (" + nextRaceCar + ")", BTT.UCID, 0);
                            }
                        }
                        catch
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7Allowed range: 0kg - " + cars.maxAddMass(nextRaceCar) + "kg (" + nextRaceCar + ")", BTT.UCID, 0);
                        }
                    }
                    else
                    {
                        InSim.Send_MTC_MessageToConnection("Unavailable while racing", BTT.UCID, 0);
                    }
                    break;
            }
		}

		// A penalty give or cleared
        private void PEN_PenaltyChanged(Packets.IS_PEN PEN)
        {
            if (PEN.Reason == Enums.PenaltyReason.PENR_ADMIN && PEN.NewPen == Enums.Penalty.PENALTY_NONE && PEN.OldPen != Enums.Penalty.PENALTY_NONE)
            {
                InSim.Send_MST_Message("/msg ^3 ^7Unauthorized penalty change! Action log updated!");
            }
            if (PEN.Reason == Enums.PenaltyReason.PENR_UNKNOWN)
            {
                Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].startPenaltyApplyNow = false;
            }

            Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penSum += 1;
            if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
            {
                Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penFromBlankSum += 1;
            }
            switch (PEN.Reason)
            {
                case Enums.PenaltyReason.PENR_ADMIN:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penFromAdminSum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penFromAdminFromBlankSum += 1;
                    }
                    break;

                case Enums.PenaltyReason.PENR_FALSE_START:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penFalseStartSum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penFalseStartFromBlankSum += 1;
                    }
                    break;

                case Enums.PenaltyReason.PENR_NUM:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penNumSum += 1;
                    break;

                case Enums.PenaltyReason.PENR_SPEEDING:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penSpeedingSum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penSpeedingFromBlankSum += 1;
                    }
                    break;

                case Enums.PenaltyReason.PENR_STOP_LATE:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penPitStopTooLateSum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penPitStopTooLateFromBlankSum += 1;
                    }
                    break;

                case Enums.PenaltyReason.PENR_STOP_SHORT:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penPitStopTooShortSum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penPitStopTooShortFromBlankSum += 1;
                    }
                    break;

                case Enums.PenaltyReason.PENR_UNKNOWN:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penUnknownSum += 1;
                    break;

                case Enums.PenaltyReason.PENR_WRONG_WAY:
                    Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penWrongWaySum += 1;
                    if (PEN.OldPen == Enums.Penalty.PENALTY_NONE)
                    {
                        Connections[GetConnIdx(Players[GetPlyIdx(PEN.PLID)].UniqueID)].penWrongWayFromBlankSum += 1;
                    }
                    break;
            }
        }

		// Yellow or blue flag changed
		private void FLG_FlagChanged(Packets.IS_FLG FLG)
		{
            if (FLG.OffOn == 1 && FLG.Flag == Enums.Flags.FLAG_YELLOW)
            {
                Connections[GetConnIdx(misc.convertToUCID(FLG.PLID))].flagYellowsSum += 1;
            }
		}

		// A player entered or left the pitlane
		private void PLA_PitLaneChanged(Packets.IS_PLA PLA)
        {
            switch (PLA.Fact)
            {
                case Enums.PitLaneReason.PITLANE_DT:
                    Connections[GetConnIdx(Players[GetPlyIdx(PLA.PLID)].UniqueID)].pitlaneDtSum += 1;
                    Players[GetPlyIdx(PLA.PLID)].safSpecInvinc = true;
                    break;

                case Enums.PitLaneReason.PITLANE_ENTER:
                    Connections[GetConnIdx(Players[GetPlyIdx(PLA.PLID)].UniqueID)].pitlaneEnterSum += 1;
                    Players[GetPlyIdx(PLA.PLID)].safSpecInvinc = true;
                    break;

                case Enums.PitLaneReason.PITLANE_NO_PURPOSE:
                    Connections[GetConnIdx(Players[GetPlyIdx(PLA.PLID)].UniqueID)].pitlaneNoPurposeSum += 1;
                    Players[GetPlyIdx(PLA.PLID)].safSpecInvinc = true;
                    break;

                case Enums.PitLaneReason.PITLANE_NUM:
                    Connections[GetConnIdx(Players[GetPlyIdx(PLA.PLID)].UniqueID)].pitlaneNumSum += 1;
                    break;

                case Enums.PitLaneReason.PITLANE_SG:
                    Connections[GetConnIdx(Players[GetPlyIdx(PLA.PLID)].UniqueID)].pitlaneSgSum += 1;
                    Players[GetPlyIdx(PLA.PLID)].safSpecInvinc = true;
                    break;

                case Enums.PitLaneReason.PITLANE_EXIT:
                    Players[GetPlyIdx(PLA.PLID)].safSpecInvinc = false;
                    break;
            }
		}

		// A player crossed a lap split
		private void SPX_SplitTime(Packets.IS_SPX SPX)
		{
		}

		// A player changed it's camera
		private void CCH_CameraChanged(Packets.IS_CCH CCH)
		{
		}

		// The server/race state changed
		private void STA_StateChanged(Packets.IS_STA STA)
		{
            if (STA.ReqI == 9)
            {
                if (STA.RaceInProg == 1)
                {
                    InSim.Request_RST_RaceStart(9);
                    raceStarted = true;
                }
                if (STA.NumFinished > 0)
                {
                    InSim.Request_RES_AllResults();
                    raceStarted = false;
                }
            }
            globalVars.currentTrack = STA.Track;
            //0 - No race
            //1 - Racing
            //2 - Qualifying
            /*if (STA.RaceInProg == 1)
            {
                raceStarted = true;
                InSim.Send_MST_Message("/cars " + nextRaceCar);
            }
            else
            {
                raceStarted = false;
                InSim.Send_MST_Message("/cars ALL");
            }*/
		}

		// A host is started or joined
		private void ISM_MultiplayerInformation(Packets.IS_ISM ISM)
		{
            hostName = ISM.HName;
		}

		// A host ends or leaves
		private void MPE_MultiplayerEnd()
		{
		}

		// Race got cleared with /clear
		private void CLR_RaceCleared()
		{
		}

		// Sent at the start of every race or qualifying session, listing the start order
		private void REO_RaceStartOrder(Packets.IS_REO REO)
		{
		}

		// Race start information
        private void RST_RaceStart(Packets.IS_RST RST)
        {
            globalVars.currentTrack = RST.Track;
            if (RST.ReqI == 0)
            {
                foreach (clsPlayer P in Players)
                {
                    P.currentLap = 0;
                    if (P.CarName != nextRaceCar)
                    {
                        InSim.Send_MTC_MessageToConnection("^3 ^7You are supposed to use the race car (" + nextRaceCar + ")", P.UniqueID, 0);
                        InSim.Send_MST_Message("/spec " + Connections[GetConnIdx(P.UniqueID)].Username);
                    }
                    if (intRestEnabled == true)
                    {
                        if (P.IntakeRestriction != nextRaceIntRest)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry, but intake restriction is set to " + nextRaceIntRest + "%", P.UniqueID, 0);
                            InSim.Send_MST_Message("/spec " + misc.convertToConnection(P).Username);
                        }
                    }
                    if (addMassEnabled == true)
                    {
                        if (P.AddedMass != nextRaceAddMass)
                        {
                            InSim.Send_MTC_MessageToConnection("^3 ^7We are sorry, but added mass is set to " + nextRaceAddMass + "kg", P.UniqueID, 0);
                            InSim.Send_MST_Message("/spec " + misc.convertToConnection(P).Username);
                        }
                    }
                    misc.convertToConnection(P).authorizedStart = true;
                    P.safSpecInvinc = false;
                }
                raceStarted = true;
                InSim.Send_MST_Message("/cars " + nextRaceCar);
                buttonSequence.deleteSequence("Race settings", 255);
                foreach (clsConnection C in Connections)
                {
                    if (C.Action == "setting race details")
                    {
                        C.Action = "nothing";
                    }
                    C.racesSum += 1;
                }
                buttonSequence.deleteSequence("next race info", 255);
                lastRaceWinnerUCID = winnerUCID;
                lastRaceCar = nextRaceCar;
                winnerUCID = 0;
                winnerSet = false;
                InSim.Send_MST_Message("/msg ^3 ^7Please keep the race clean!");
                InSim.Send_MST_Message("/autokick=kick");
                InSim.Send_MST_Message("/midrace=yes");
                InSim.Send_MST_Message("/rcc_all");
                raceResCountdown = false;
                timeToResRace = 60;
                buttonSequence.createSequence("HUD", 255, null);
                InSim.Send_MST_Message("/msg ^3 ^7Checking and applying start penalties...");
                foreach (clsConnection C in Connections)
                {
                    if (C.startPenalty != null && C.startPenalty != "")
                    {
                        C.startPenaltyApplyNow = true;
                        InSim.Send_MST_Message("/p_" + C.startPenalty + " " + C.Username);
                    }
                }
                timerPauseLeftTime = 60;
                timerPaused = false;
                globalVars.currentRaceLapCount = RST.RaceLaps;
                globalVars.currentRaceRacersCount = RST.NumP;
                globalVars.currentRaceCurrentLap = 1;
            }
            else if (RST.ReqI == 9)
            {
                globalVars.currentRaceLapCount = RST.RaceLaps;
                globalVars.currentRaceRacersCount = RST.NumP;
                globalVars.currentRaceCurrentLap = 1;
                InSim.Request_MCI_MCIPacket(9);
            }

            if (RST.Flags == Flags.RaceFlags.HOSTF_CAN_RESET)
            {
                InSim.Send_MST_Message("/canreset=no");
            }
            if (RST.Flags == Flags.RaceFlags.HOSTF_CAN_SELECT)
            {
                InSim.Send_MST_Message("/select=no");
            }
            if (RST.Flags == Flags.RaceFlags.HOSTF_CAN_VOTE)
            {
                InSim.Send_MST_Message("/vote=no");
            }
            if (RST.Flags == Flags.RaceFlags.HOSTF_FCV)
            {
                InSim.Send_MST_Message("/fcv=no");
            }
            InSim.Send_MST_Message("/cruise=no");
        }

		// Qualify or confirmed finish
        private void RES_RaceOrQualifyingResult(Packets.IS_RES RES)
        {
            if (Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].winnerOfLastRace == false)
            {
                Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].currWinsInARow = 0;
            }
            if (RES.Confirm == Flags.ConfirmationFlags.CONF_CONFIRMED && RES.ResultNum <= 32 && Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].authorizedStart == true)
            {
                switch (RES.ResultNum)
                {
                    case 0:
                        winnerSet = true;
                        winnerUCID = Players[GetPlyIdx(RES.PLID)].UniqueID;
                        InSim.Send_MST_Message("/msg ^3 ^7Congratulations, " + Players[GetPlyIdx(RES.PLID)].PlayerName);
                        InSim.Send_MTC_MessageToConnection("^3 ^7You can now set the details for the next race.", misc.convertToUCID(RES.PLID), 0);
                        InSim.Send_MTC_MessageToConnection("^3 ^7Command to set the details: !racesettings or !rs", misc.convertToUCID(RES.PLID), 0);
                        InSim.Send_MST_Message("/cars ALL");
                        raceStarted = false;
                        InSim.Send_MST_Message("/autokick=no");
                        timeSinceEndOfRace = 0;
                        Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].racesWon += 1;

                        if (globalVars.currentRaceRacersCount > 2)
                        {
                            Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].currWinsInARow += 1;
                        }
                        if (Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].currWinsInARow > Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].maxWinsInARow)
                        {
                            Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].maxWinsInARow = Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].currWinsInARow;
                        }
                        Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].winnerOfLastRace = true;
                        break;

                    case 1:
                        Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].racesSecond += 1;
                        break;

                    case 2:
                        Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].racesThird += 1;
                        break;
                }
                int ptsToGive = globalVars.currentRaceRacersCount - RES.ResultNum;
                if (ptsToGive > 32)
                {
                    ptsToGive = 0;
                }
                if (ptsToGive == 1)
                {
                    InSim.Send_MST_Message("/msg ^3 ^7" + Players[GetPlyIdx(RES.PLID)].PlayerName + " ^7won ^2" + ptsToGive + "point^7!");
                    Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].pointsBronze += ptsToGive;
                }
                else if (ptsToGive > 1)
                {
                    InSim.Send_MST_Message("/msg ^3 ^7" + Players[GetPlyIdx(RES.PLID)].PlayerName + " ^7won ^2" + ptsToGive + "points^7!");
                    Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].pointsBronze += ptsToGive;
                }
                else
                {
                    InSim.Send_MST_Message("/msg ^3 ^7" + Players[GetPlyIdx(RES.PLID)].PlayerName + " ^7did not win any points!");
                }
            }
            else
            {
                InSim.Send_MST_Message("/msg ^3 ^7" + Players[GetPlyIdx(RES.PLID)].PlayerName + " ^7did not win any points!");
            }
            Connections[GetConnIdx(Players[GetPlyIdx(RES.PLID)].UniqueID)].authorizedStart = false;
        }

		// A race ends (return to game setup screen)
		private void REN_RaceEnds()
		{
            raceStarted = false;
		}

		// Current race time progress in hundredths
		private void RTP_RaceTime(uint RTP)
		{
		}

		// Autocross got cleared
		private void AXC_AutocrossCleared()
		{
		}

		// Request - autocross layout information
		private void AXI_AutocrossLayoutInformation(Packets.IS_AXI AXI)
		{
		}

		// LFS reporting camera position and state
		private void CPP_CameraPosition(Packets.IS_CPP CPP)
		{
		}

		// A vote completed
		private void VTA_VoteAction(byte VTA)
		{
		}

		// A vote got canceled
		private void VTC_VoteCanceled()
		{
		}

		// A vote got called
		private void VTN_VoteNotify(Packets.IS_VTN VTN)
		{
            
		}

		// Detailed car information packet (max 8 per packet)
		private void MCI_CarInformation(Packets.IS_MCI MCI)
		{
            try
            {
                if (MCI.ReqI == 0)
                {
                    //CompCar is the CompCar packet structure I added to clsPlayer
                    for (int i = 0; i < MCI.NumC; i++)
                    {
                        int idx = 0;
                        idx = GetPlyIdx(MCI.Info[i].PLID);
                        Players[idx].CompCarPrev.AngVel = Players[idx].CompCar.AngVel; //They aren't structures so you cant serialize!
                        Players[idx].CompCarPrev.Direction = Players[idx].CompCar.Direction;
                        Players[idx].CompCarPrev.Heading = Players[idx].CompCar.Heading;
                        Players[idx].CompCarPrev.Info = Players[idx].CompCar.Info;
                        Players[idx].CompCarPrev.Lap = Players[idx].CompCar.Lap;
                        Players[idx].CompCarPrev.Node = Players[idx].CompCar.Node;
                        Players[idx].CompCarPrev.PLID = Players[idx].CompCar.PLID;
                        Players[idx].CompCarPrev.Position = Players[idx].CompCar.Position;
                        Players[idx].CompCarPrev.Speed = Players[idx].CompCar.Speed;
                        Players[idx].CompCarPrev.X = Players[idx].CompCar.X;
                        Players[idx].CompCarPrev.Y = Players[idx].CompCar.Y;
                        Players[idx].CompCarPrev.Z = Players[idx].CompCar.Z;

                        Players[idx].CompCar.AngVel = MCI.Info[i].AngVel; //They aren't structures so you cant serialize!
                        Players[idx].CompCar.Direction = MCI.Info[i].Direction;
                        Players[idx].CompCar.Heading = MCI.Info[i].Heading;
                        Players[idx].CompCar.Info = MCI.Info[i].Info;
                        Players[idx].CompCar.Lap = MCI.Info[i].Lap;
                        Players[idx].CompCar.Node = MCI.Info[i].Node;
                        Players[idx].CompCar.PLID = MCI.Info[i].PLID;
                        Players[idx].CompCar.Position = MCI.Info[i].Position;
                        Players[idx].CompCar.Speed = MCI.Info[i].Speed;
                        Players[idx].CompCar.X = MCI.Info[i].X;
                        Players[idx].CompCar.Y = MCI.Info[i].Y;
                        Players[idx].CompCar.Z = MCI.Info[i].Z;

                        if (Players[idx].CompCarPrev.X == 0 && Players[idx].CompCarPrev.Y == 0 && Players[idx].CompCarPrev.Z == 0)
                        {
                            Players[idx].CompCarPrev.AngVel = Players[idx].CompCar.AngVel; //They aren't structures so you cant serialize!
                            Players[idx].CompCarPrev.Direction = Players[idx].CompCar.Direction;
                            Players[idx].CompCarPrev.Heading = Players[idx].CompCar.Heading;
                            Players[idx].CompCarPrev.Info = Players[idx].CompCar.Info;
                            Players[idx].CompCarPrev.Lap = Players[idx].CompCar.Lap;
                            Players[idx].CompCarPrev.Node = Players[idx].CompCar.Node;
                            Players[idx].CompCarPrev.PLID = Players[idx].CompCar.PLID;
                            Players[idx].CompCarPrev.Position = Players[idx].CompCar.Position;
                            Players[idx].CompCarPrev.Speed = Players[idx].CompCar.Speed;
                            Players[idx].CompCarPrev.X = Players[idx].CompCar.X;
                            Players[idx].CompCarPrev.Y = Players[idx].CompCar.Y;
                            Players[idx].CompCarPrev.Z = Players[idx].CompCar.Z;
                        }
                        //<--------------------------------------------------------------
                    }
                    for (int i = 0; i < MCI.NumC; i++)
                    {
                        Players[GetPlyIdx(MCI.Info[i].PLID)].currentPosition = MCI.Info[i].Position;

                        int numThreats = 0;
                        if (MathHelper.SpeedToKph(MCI.Info[i].Speed) > 5 && raceStarted == true)
                        {
                            for (int ii = 0; ii < Players.Count; ii++)
                            {
                                double currDistPrev = MathHelper.LengthToMetres(MathHelper.Distance(Players[GetPlyIdx(MCI.Info[i].PLID)].CompCarPrev.X, Players[GetPlyIdx(MCI.Info[i].PLID)].CompCarPrev.Y, Players[GetPlyIdx(MCI.Info[i].PLID)].CompCarPrev.Z, Players[ii].CompCarPrev.X, Players[ii].CompCarPrev.Y, Players[ii].CompCarPrev.Z));

                                double currDist = MathHelper.LengthToMetres(MathHelper.Distance(Players[GetPlyIdx(MCI.Info[i].PLID)].CompCar.X, Players[GetPlyIdx(MCI.Info[i].PLID)].CompCar.Y, Players[GetPlyIdx(MCI.Info[i].PLID)].CompCar.Z, Players[ii].CompCar.X, Players[ii].CompCar.Y, Players[ii].CompCar.Z));
                                double speedMps = MathHelper.SpeedToMps(Players[GetPlyIdx(MCI.Info[i].PLID)].CompCar.Speed - Players[ii].CompCar.Speed);
                                double timeToImpact = currDist / speedMps;
                                if (timeToImpact < 10 && Players[GetPlyIdx(MCI.Info[i].PLID)].currentLap >= Players[ii].currentLap && MathHelper.SpeedToKph(Players[ii].CompCar.Speed) < 5 && Players[ii].safSpecInvinc == false && (currDist * 3) < (currDistPrev * 3))
                                {
                                    InSim.Send_BTN_CreateButton("", Flags.ButtonStyles.ISB_DARK, (byte)(5 + (5 * numThreats)), 60, (byte)60, 70, 200, Players[GetPlyIdx(MCI.Info[i].PLID)].UniqueID, 50, false);
                                    InSim.Send_BTN_CreateButton("^1Danger ahead -> ^7" + Players[ii].PlayerName + " ^6:: ^7Distance: ^3" + (int)currDist + "m ^6:: ^7Time to impact: ^3" + (int)timeToImpact + "seconds", Flags.ButtonStyles.ISB_LEFT, 5, 60, (byte)(60 + (5 * numThreats)), 70, (byte)(201 + numThreats), Players[GetPlyIdx(MCI.Info[i].PLID)].UniqueID, 50, false);
                                    numThreats += 1;
                                    if (timeToImpact < 1.5)
                                    {
                                        Players[ii].safSpecInvinc = true;
                                        InSim.Send_MST_Message("/spec " + misc.convertToConnection(Players[ii]).Username);
                                        InSim.Send_MST_Message("/msg " + Players[ii].PlayerName + " ^8: SPECTATED FOR SAFETY");
                                    }
                                }
                            }
                        }
                        if (numThreats == 0 && misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev > 0)
                        {
                            InSim.Send_BFN_DeleteButton(Enums.BtnFunc.BFN_DEL_BTN, 200, Players[GetPlyIdx(MCI.Info[i].PLID)].UniqueID);
                            for (int iii = 0; iii < misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev; iii++)
                            {
                                InSim.Send_BFN_DeleteButton(Enums.BtnFunc.BFN_DEL_BTN, (byte)(200 + (misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev - iii)), Players[GetPlyIdx(MCI.Info[i].PLID)].UniqueID);
                            }
                        }
                        else if (misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev > numThreats)
                        {
                            for (int iii = 0; iii < misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev; iii++)
                            {
                                InSim.Send_BFN_DeleteButton(Enums.BtnFunc.BFN_DEL_BTN, (byte)(200 + (misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev - iii)), Players[GetPlyIdx(MCI.Info[i].PLID)].UniqueID);
                            }
                        }

                        misc.convertToConnection(Players[GetPlyIdx(MCI.Info[i].PLID)]).numThreatsPrev = numThreats;
                    }
                }
                else if (MCI.ReqI == 9)
                {
                    for (int i = 0; i < MCI.NumC; i++)
                    {
                        if (globalVars.currentTrack != "AU1" && globalVars.currentTrack != "AU3")
                        {
                            if (MCI.Info[i].Position == 1)
                            {
                                InSim.Send_MST_Message("/msg ^3 ^7InSim synchronizing with current race:");
                                globalVars.currentRaceCurrentLap = MCI.Info[i].Lap;
                                nextRaceCar = Players[GetPlyIdx(MCI.Info[i].PLID)].CarName;
                                lastRaceCar = Players[GetPlyIdx(MCI.Info[i].PLID)].CarName;
                                buttonSequence.createSequence("HUD", 255, null);
                                InSim.Send_MST_Message("/msg ^3 ^7Car detected: ^3" + nextRaceCar);
                                InSim.Send_MST_Message("/msg ^3 ^7Current lap detected: ^3" + globalVars.currentRaceCurrentLap);
                                InSim.Send_MST_Message("/msg ^3 ^7Amount of racers detected: ^3" + globalVars.currentRaceRacersCount);
                                InSim.Send_MST_Message("/msg ^3 ^7Current track: ^3" + globalVars.currentTrack);
                                return;
                            }
                        }
                        else
                        {
                            if (MCI.Info[i].Info == Flags.CompCarFlags.CCI_FIRST)
                            {
                                InSim.Send_MST_Message("/msg ^3 ^7InSim synchronizing with current race:");
                                globalVars.currentRaceCurrentLap = MCI.Info[i].Lap;
                                nextRaceCar = Players[GetPlyIdx(MCI.Info[i].PLID)].CarName;
                                lastRaceCar = Players[GetPlyIdx(MCI.Info[i].PLID)].CarName;
                                buttonSequence.createSequence("HUD", 255, null);
                                InSim.Send_MST_Message("/msg ^3 ^7Car detected: ^3" + nextRaceCar);
                                InSim.Send_MST_Message("/msg ^3 ^7Current lap detected: ^3" + globalVars.currentRaceCurrentLap);
                                InSim.Send_MST_Message("/msg ^3 ^7Amount of racers detected: ^3" + globalVars.currentRaceRacersCount);
                                InSim.Send_MST_Message("/msg ^3 ^7Current track: ^3" + globalVars.currentTrack);
                                return;
                            }
                        }
                    }
                    InSim.Send_MST_Message("/msg ^3 ^7InSim startup synchronization has ^1failed^7.");
                }
            }
            catch { }
		}

        // Compact car information packet
        private void NLP_LapNode(Packets.IS_NLP NLP)
        {
		}

		// A /i message got sent to this program
		private void III_InSimInfo(Packets.IS_III III)
		{
		}

		// InSim version information
		private void VER_InSimVersionInformation(Packets.IS_VER VER)
		{
		}

		// Reply to a ping request
		private void REPLY_PingReplay()
		{
		}

		#endregion

        private void button1_Click(object sender, EventArgs e)
        {
            string[] StrTxt2 = textBox2.Text.Split(' ');
            if (StrTxt2[0].ToLower() == "-dev")
            {
                switch (StrTxt2[1].ToLower())
                {
                    case "dtntb":
                        if (MessageBox.Show(DateTime.Now.ToBinary() + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(DateTime.Now.ToBinary().ToString()); }
                        break;

                    case "dtstb":
                        if (MessageBox.Show(DateTime.Now.ToBinary() + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(DateTime.Now.ToBinary().ToString()); }
                        break;

                    case "dtnub":
                        if (MessageBox.Show(DateTime.FromBinary(Convert.ToInt64(StrTxt2[2].Trim())) + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(DateTime.FromBinary(Convert.ToInt64(StrTxt2[2].Trim())).ToString()); }
                        break;

                    case "gethash":
                        if (MessageBox.Show(StrTxt2[2].Trim().GetHashCode() + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(StrTxt2[2].Trim().GetHashCode().ToString()); }
                        break;

                    case "intmax":
                        if (MessageBox.Show(int.MaxValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(int.MaxValue.ToString()); }
                        break;

                    case "int16max":
                        if (MessageBox.Show(Int16.MaxValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int16.MaxValue.ToString()); }
                        break;

                    case "int32max":
                        if (MessageBox.Show(Int32.MaxValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int32.MaxValue.ToString()); }
                        break;

                    case "int64max":
                        if (MessageBox.Show(Int64.MaxValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int64.MaxValue.ToString()); }
                        break;

                    case "intmin":
                        if (MessageBox.Show(int.MinValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(int.MinValue.ToString()); }
                        break;

                    case "int16min":
                        if (MessageBox.Show(Int16.MinValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int16.MinValue.ToString()); }
                        break;

                    case "int32min":
                        if (MessageBox.Show(Int32.MinValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int32.MinValue.ToString()); }
                        break;

                    case "int64min":
                        if (MessageBox.Show(Int64.MinValue + Environment.NewLine + Environment.NewLine + "Copy value to clipboard?", "-OsT- InSim app. dev. mode", MessageBoxButtons.YesNo) == DialogResult.Yes) { misc.clipboardsettext(Int64.MinValue.ToString()); }
                        break;
                }
            }
            else
            {
                InSim.Send_MST_Message(textBox2.Text);
                textBox2.Text = "";
                textBox2.Focus();
            }
        }

        private void oneSecTimer_Tick(object sender, EventArgs e)
        {
            #region Car pick timer (CPT)
            try
            {
                if (winnerSet == true && timeSinceEndOfRace != 255 && timerPaused == false)
                {
                    switch (timeSinceEndOfRace)
                    {
                        case 0:
                            InSim.Send_MST_Message("/msg ^3 ^760 seconds timer to pick next car.");
                            break;

                        case 30:
                            InSim.Send_MST_Message("/msg ^3 ^730 seconds left to pick next car.");
                            break;

                        case 50:
                            InSim.Send_MST_Message("/msg ^3 ^710 seconds left to pick next car.");
                            break;
                    }
                    if (timeSinceEndOfRace < 60)
                    {
                        timeSinceEndOfRace += 1;
                    }
                    else
                    {
                        raceResCountdown = true;
                        timeToResRace = 60;

                        nextRaceCar = cars.getAllowedRandCar();
                        InSim.Send_MST_Message("/msg ^3 ^7Failed to pick next car in time. Random car picked.");

                        buttonSequence.createSequence("HUD", 255, null);
                        buttonSequence.deleteSequence("race settings", 255);
                        foreach (clsConnection C in Connections)
                        {
                            if (C.Action == "setting race details")
                            {
                                C.Action = "nothing";
                            }
                        }
                        InSim.Send_MST_Message("/msg ^3 ^7Nobody chose " + nextRaceCar + " for next race.");
                        intRestEnabled = false;
                        addMassEnabled = false;
                        buttonSequence.createSequence("next race info", 255, null);
                        timeSinceEndOfRace = 255;

                        InSim.Send_MST_Message("/cars " + nextRaceCar);
                        string NRINR1 = "--";
                        string NRADM1 = "---";
                        if (intRestEnabled == true)
                        {
                            NRINR1 = nextRaceIntRest.ToString();
                        }
                        if (addMassEnabled == true)
                        {
                            NRADM1 = nextRaceAddMass.ToString();
                        }
                        InSim.Send_MST_Message("/msg ^3 ^7Race locked: " + nextRaceCar + " | " + NRINR1 + "% | " + NRADM1 + "kg");
                        winnerUCID = 0;
                    }
                }
            }
            catch (Exception E)
            {
                string[] addInf = ("winnerSet = " + winnerSet.ToString() + "|" + "timeSinceEndOfRace = " + timeSinceEndOfRace).Split('|');
                misc.buildErrorReportOnCrash(E, "TMR-TICK-CPT", "TMRTICK", addInf, "");
            }
            #endregion

            #region Vote count down (VCD)
            //VOTE Count down
            try
            {
                if (voteVote != "" && voteVote != null && voteIdleTime != 255)
                {
                    if (voteIdleTime >= 1)
                    {
                        voteIdleTime -= 1;
                    }
                    else
                    {
                        if (voteExpired == false)
                        {
                            InSim.Send_MST_Message("/msg ^3 ^7Vote expired. Giving extra 10 seconds.");
                            voteIdleTime = 10;
                            voteExpired = true;
                        }
                        else
                        {
                            InSim.Send_MST_Message("/msg ^3 ^7Vote expired. Cancelling vote.");
                            voteIdleTime = 255;
                            voteExpired = false;
                            voteVote = "";
                            voteVoters = "";
                            voteVotes = 0;
                        }
                    }
                }
            }
            catch (Exception E)
            {
                string[] addInf = ("voteVote = " + voteVote + "|" + "voteIdleTime = " + voteIdleTime + "|" + "voteExpired = " + voteExpired.ToString() + "|" + "voteVoters = " + voteVoters + "|" + "voteVotes = " + voteVotes).Split('|');
                misc.buildErrorReportOnCrash(E, "TMR-TICK-VCD", "TMRTICK", addInf, "");
            }
            #endregion

            #region Race start count down (RSCD)
            try
            {
                if (raceResCountdown == true && Players.Count > 0)
                {
                    if (timeToResRace == 30)
                    {
                        if (winnerSet == true)
                        {
                            InSim.Send_MST_Message("/cars " + nextRaceCar);
                            string NRINR1 = "--";
                            string NRADM1 = "---";
                            if (intRestEnabled == true)
                            {
                                NRINR1 = nextRaceIntRest.ToString();
                            }
                            if (addMassEnabled == true)
                            {
                                NRADM1 = nextRaceAddMass.ToString();
                            }
                            InSim.Send_MST_Message("/msg ^3 ^7Race locked: " + nextRaceCar + " | " + NRINR1 + "% | " + NRADM1 + "kg");
                            buttonSequence.deleteSequence("race settings", 255);
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Action == "setting race details")
                                {
                                    C.Action = "nothing";
                                }
                            }
                            buttonSequence.createSequence("HUD", 255, null);
                            winnerUCID = 0;
                        }
                        else
                        {
                            InSim.Send_MST_Message("/cars " + nextRaceCar);
                            string NRINR1 = "--";
                            string NRADM1 = "---";
                            if (intRestEnabled == true)
                            {
                                NRINR1 = nextRaceIntRest.ToString();
                            }
                            if (addMassEnabled == true)
                            {
                                NRADM1 = nextRaceAddMass.ToString();
                            }
                            InSim.Send_MST_Message("/msg ^3 ^7Race reminder: " + nextRaceCar + " | " + NRINR1 + "% | " + NRADM1 + "kg");
                            buttonSequence.deleteSequence("race settings", 255);
                            foreach (clsConnection C in Connections)
                            {
                                if (C.Action == "setting race details")
                                {
                                    C.Action = "nothing";
                                }
                            }
                            buttonSequence.createSequence("HUD", 255, null);
                            winnerUCID = 0;
                        }
                    }

                    if (timeToResRace > 0)
                    {
                        timeToResRace -= 1;
                        buttonSequence.createSequence("HUD", 255, null);
                    }
                    else
                    {
                        timeToResRace = 60;
                        raceResCountdown = false;
                        InSim.Send_MST_Message("/cars " + nextRaceCar);
                        InSim.Send_MST_Message("/restart");
                        buttonSequence.createSequence("HUD", 255, null);
                        raceStarted = true;
                        winnerUCID = 0;
                    }
                }
            }
            catch (Exception E)
            {
                string[] addInf = ("raceResCountdown = " + raceResCountdown.ToString() + "|" + "Players.Count = " + Players.Count + "|" + "timeToResRace = " + timeToResRace + "|" + "raceStarted = " + raceStarted.ToString() + "|" + "winnerSet = " + winnerSet.ToString()).Split('|');
                misc.buildErrorReportOnCrash(E, "TMR-TICK-RSCD", "TMRTICK", addInf, "/globalError");
            }
            #endregion

            #region Timer pause count down
            if (timerPaused == true)
            {
                if (timerPauseLeftTime > 0)
                {
                    timerPauseLeftTime -= 1;
                    foreach (clsConnection C in Connections)
                    {
                        if (C.Action == "setting race details")
                        {
                            buttonSequence.createSequence("race settings pt", C.UniqueID, C);
                        }
                    }
                }
                else
                {
                    foreach (clsConnection C in Connections)
                    {
                        if (C.Action == "setting race details")
                        {
                            buttonSequence.createSequence("race settings", C.UniqueID, C);
                        }
                    }
                    buttonSequence.createSequence("HUD", 255, null);
                    winnerUCID = 0;

                    //LOL
                    timerPaused = false;
                    raceResCountdown = false;
                }
            }
            #endregion
        }
	}
}